/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.Image;
import java.net.Authenticator;
import java.util.Hashtable;
import javax.swing.Icon;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.scout.rt.client.ui.BundleIconLocator;
import org.eclipse.scout.rt.client.ui.IIconLocator;
import org.eclipse.scout.rt.ui.swing.SwingIconLocator;
import org.eclipse.scout.rt.ui.swing.SwingIcons;
import org.eclipse.scout.rt.ui.swing.login.internal.InternalNetAuthenticator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends Plugin
implements SwingIcons {
    public static final String PLUGIN_ID = "org.eclipse.scout.rt.ui.swing";
    private static Activator plugin;
    private SwingIconLocator m_iconLocator;
    private ServiceRegistration m_netAuthRegistration;

    public static Activator getDefault() {
        return plugin;
    }

    public static Image getImage(String name) {
        return Activator.getDefault().getImageImpl(name);
    }

    private Image getImageImpl(String name) {
        return this.m_iconLocator.getImage(name);
    }

    public static Icon getIcon(String name) {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            return activator.getIconImpl(name);
        }
        return null;
    }

    private Icon getIconImpl(String name) {
        return this.m_iconLocator.getIcon(name);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        BundleIconLocator iconLocator = new BundleIconLocator(this.getBundle());
        iconLocator.getIconLocatorService().setFolderName("resources/icons/internal/");
        this.m_iconLocator = new SwingIconLocator((IIconLocator)iconLocator);
        Hashtable<String, Integer> map = new Hashtable<String, Integer>();
        map.put("service.ranking", -2);
        this.m_netAuthRegistration = Activator.getDefault().getBundle().getBundleContext().registerService(Authenticator.class.getName(), (Object)new InternalNetAuthenticator(), map);
    }

    public void stop(BundleContext context) throws Exception {
        this.m_iconLocator = null;
        if (this.m_netAuthRegistration != null) {
            this.m_netAuthRegistration.unregister();
            this.m_netAuthRegistration = null;
        }
        plugin = null;
        super.stop(context);
    }
}

