/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.extension.FormFieldsExtensionPoint;
import org.eclipse.scout.rt.ui.swing.extension.IFormFieldExtension;
import org.eclipse.scout.rt.ui.swing.extension.IFormFieldFactory;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.osgi.framework.Bundle;

public class FormFieldFactory
implements IFormFieldFactory {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(FormFieldFactory.class);
    private LinkedHashMap<Class<?>, IFormFieldFactory> m_fields;

    public FormFieldFactory() {
        TreeMap<CompositeObject, P_FormFieldExtension> sortedMap = new TreeMap<CompositeObject, P_FormFieldExtension>();
        IFormFieldExtension[] iFormFieldExtensionArray = FormFieldsExtensionPoint.getFormFieldExtensions();
        int n = iFormFieldExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle loaderBundle;
            IFormFieldExtension extension = iFormFieldExtensionArray[n2];
            if (extension.isActive() && (loaderBundle = Platform.getBundle((String)extension.getContibuterBundleId())) != null) {
                Class uiClazz = null;
                Class factoryClazz = null;
                try {
                    Class modelClazz = loaderBundle.loadClass(extension.getModelClassName());
                    if (!StringUtility.isNullOrEmpty((String)extension.getUiClassName())) {
                        uiClazz = loaderBundle.loadClass(extension.getUiClassName());
                        if (!ISwingScoutFormField.class.isAssignableFrom(uiClazz)) {
                            LOG.warn("extension '" + extension.getName() + "' contributed by '" + extension.getContibuterBundleId() + "' has an ui class not instanceof " + ISwingScoutFormField.class.getName() + ".");
                            uiClazz = null;
                        }
                    } else if (!StringUtility.isNullOrEmpty((String)extension.getFactoryClassName()) && !IFormFieldFactory.class.isAssignableFrom(factoryClazz = loaderBundle.loadClass(extension.getFactoryClassName()))) {
                        LOG.warn("extension '" + extension.getName() + "' contributed by '" + extension.getContibuterBundleId() + "' has a facotry class not instanceof " + IFormFieldFactory.class.getName() + ".");
                        factoryClazz = null;
                    }
                    IFormFieldFactory factory = null;
                    if (uiClazz != null) {
                        factory = new P_DirectLinkFormFieldFactory(uiClazz);
                    } else if (factoryClazz != null) {
                        try {
                            factory = (IFormFieldFactory)factoryClazz.newInstance();
                        }
                        catch (Exception e) {
                            LOG.warn("could not create a factory instance of '" + factoryClazz.getName() + "' ", (Throwable)e);
                        }
                    } else {
                        LOG.debug("extension '" + extension.getName() + "' contributed by '" + extension.getContibuterBundleId() + "' has neither an UiClass nor a factory defined! Skipping extension.");
                        break;
                    }
                    int distance = -FormFieldFactory.distanceToIFormField(modelClazz, 0);
                    CompositeObject key = new CompositeObject(new Object[]{distance, modelClazz.getName()});
                    if (sortedMap.containsKey(key)) {
                        P_FormFieldExtension existingExt = (P_FormFieldExtension)sortedMap.get(key);
                        if (existingExt.getFormFieldExtension().getScope() == extension.getScope()) {
                            LOG.warn("The bundles '" + extension.getContibuterBundleId() + "' and '" + existingExt.getFormFieldExtension().getContibuterBundleId() + "' are both providing " + "an form field extension to '" + extension.getModelClassName() + "' with the same scope.");
                        } else if (existingExt.getFormFieldExtension().getScope() < extension.getScope()) {
                            sortedMap.put(key, new P_FormFieldExtension(modelClazz, factory, extension));
                        }
                    } else {
                        sortedMap.put(key, new P_FormFieldExtension(modelClazz, factory, extension));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.debug("local extension '" + extension.getName() + "' contributed by '" + extension.getContibuterBundleId() + "' is not visible from bundle: '" + loaderBundle.getSymbolicName() + "'.");
                }
            }
            ++n2;
        }
        this.m_fields = new LinkedHashMap();
        for (P_FormFieldExtension ext : sortedMap.values()) {
            this.m_fields.put(ext.getModelClazz(), ext.getFactory());
        }
    }

    private static int distanceToIFormField(Class<?> visitee, int dist) {
        Class<?>[] interfaces;
        if (visitee == IFormField.class) {
            return dist;
        }
        int locDist = 100000;
        Class<?> superclass = visitee.getSuperclass();
        if (superclass != null) {
            locDist = FormFieldFactory.distanceToIFormField(superclass, dist + 1);
        }
        if ((interfaces = visitee.getInterfaces()) != null) {
            Class<?>[] classArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                locDist = Math.min(locDist, FormFieldFactory.distanceToIFormField(i, dist + 1));
                ++n2;
            }
        }
        dist = locDist;
        return dist;
    }

    @Override
    public ISwingScoutFormField<?> createFormField(JComponent parent, IFormField model, ISwingEnvironment environment) {
        IFormFieldFactory factory = null;
        for (Map.Entry<Class<?>, IFormFieldFactory> link : this.m_fields.entrySet()) {
            if (!link.getKey().isAssignableFrom(model.getClass())) continue;
            factory = link.getValue();
            try {
                return factory.createFormField(parent, model, environment);
            }
            catch (Throwable e) {
                LOG.error("could not create form field for: [model = '" + model.getClass().getName() + "'; ui = '" + factory.toString() + "'].", e);
            }
        }
        if (factory != null) {
            try {
                return factory.createFormField(parent, model, environment);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private class P_DirectLinkFormFieldFactory
    implements IFormFieldFactory {
        private final Class<? extends ISwingScoutFormField> m_uiClazz;

        public P_DirectLinkFormFieldFactory(Class<? extends ISwingScoutFormField> uiClazz) {
            this.m_uiClazz = uiClazz;
        }

        @Override
        public ISwingScoutFormField<?> createFormField(JComponent parent, IFormField field, ISwingEnvironment environment) {
            try {
                ISwingScoutFormField newInstance = this.m_uiClazz.newInstance();
                newInstance.createField(field, environment);
                return newInstance;
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
                return null;
            }
        }

        public String toString() {
            return "DirectLinkFactory to: " + this.m_uiClazz.getName();
        }
    }

    private class P_FormFieldExtension {
        private final Class<?> m_modelClazz;
        private final IFormFieldFactory m_factory;
        private final IFormFieldExtension m_formFieldExtension;

        public P_FormFieldExtension(Class<?> modelClazz, IFormFieldFactory factory, IFormFieldExtension formFieldExtension) {
            this.m_modelClazz = modelClazz;
            this.m_factory = factory;
            this.m_formFieldExtension = formFieldExtension;
        }

        public Class<?> getModelClazz() {
            return this.m_modelClazz;
        }

        public IFormFieldFactory getFactory() {
            return this.m_factory;
        }

        public IFormFieldExtension getFormFieldExtension() {
            return this.m_formFieldExtension;
        }
    }
}

