/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.client.ui.IIconLocator;
import org.eclipse.scout.rt.shared.AbstractIcons;

public class SwingIconLocator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingIconLocator.class);
    private final Object m_cacheLock = new Object();
    private final HashMap<String, Image> m_imagesByNameCache = new HashMap();
    private final IIconLocator m_iconLocator;

    public SwingIconLocator(IIconLocator iconLocator) {
        this.m_iconLocator = iconLocator;
    }

    public Icon getIcon(String name) {
        if (name == null || AbstractIcons.Null.equals(name)) {
            return null;
        }
        Image img = this.getImage(name);
        if (img != null) {
            return new ImageIcon(img, name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String name) {
        Image img;
        if (name.length() == 0) {
            return null;
        }
        Object object = this.m_cacheLock;
        synchronized (object) {
            img = this.m_imagesByNameCache.get(name);
            if (img == null && !this.m_imagesByNameCache.containsKey(name)) {
                img = this.createImageImpl(name);
                this.m_imagesByNameCache.put(name, img);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("load image '" + name + "' as " + img);
                }
                if (img == null) {
                    this.warnImageNotFound(name);
                }
            }
        }
        return img;
    }

    protected void warnImageNotFound(String name) {
        if (name.equals("window")) {
            return;
        }
        if (name.matches(".*(_active|_disabled|_mouse|_open|_over|_pressed|_rollover|_selected)")) {
            return;
        }
        LOG.warn("could not find image '" + name + "'");
    }

    private Image createImageImpl(String name) {
        IconSpec iconSpec = this.m_iconLocator.getIconSpec(name);
        if (iconSpec != null) {
            Image img = Toolkit.getDefaultToolkit().createImage(iconSpec.getContent());
            if (img != null && Platform.inDevelopmentMode() && name != null && name.matches("^(window\\d+|tray)$")) {
                img = this.decorateForDevelopment(img);
            }
            return img;
        }
        return null;
    }

    protected Image decorateForDevelopment(Image img) {
        if (img == null) {
            return img;
        }
        try {
            ImageIcon icon = new ImageIcon(img);
            int w = icon.getIconWidth();
            int h = icon.getIconHeight();
            BufferedImage devImg = new BufferedImage(w, h, 2);
            Graphics g = devImg.getGraphics();
            icon.paintIcon(null, g, 0, 0);
            ColorConvertOp grayOp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            grayOp.filter(devImg, devImg);
            g.dispose();
            return devImg;
        }
        catch (Throwable throwable) {
            return img;
        }
    }
}

