/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.View;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;

public final class SwingLayoutUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingLayoutUtility.class);
    public static final int MIN = 0;
    public static final int PREF = 1;
    public static final int MAX = 2;
    private static int textFieldTopInset = 0;
    private static boolean dumpSizeTreeRunning;

    static {
        Border textFieldBorder = UIManager.getBorder("TextField.border");
        if (textFieldBorder != null) {
            textFieldTopInset = textFieldBorder.getBorderInsets((Component)new JTextField((String)"X")).top;
        }
    }

    private SwingLayoutUtility() {
    }

    public static int getTextFieldTopInset() {
        return textFieldTopInset;
    }

    public static Dimension getPreferredLabelSize(JLabel c, int widthHint) {
        View v = (View)c.getClientProperty("html");
        if (v == null) {
            return c.getPreferredSize();
        }
        String text = c.getText();
        Icon icon = c.isEnabled() ? c.getIcon() : c.getDisabledIcon();
        int hAlign = c.getHorizontalAlignment();
        int vAlign = c.getVerticalAlignment();
        int hTextPosition = c.getHorizontalTextPosition();
        int vTextPosition = c.getVerticalTextPosition();
        int iconTextGap = c.getIconTextGap();
        Font font = c.getFont();
        Insets insets = c.getInsets(new Insets(0, 0, 0, 0));
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        if (icon == null && (text == null || font == null)) {
            return new Dimension(dx, dy);
        }
        if (text == null || icon != null && font == null) {
            return new Dimension((icon != null ? icon.getIconWidth() : 0) + dx, (icon != null ? icon.getIconHeight() : 0) + dy);
        }
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle();
        FontMetrics fm = c.getFontMetrics(font);
        iconR.height = 0;
        iconR.width = 0;
        iconR.y = 0;
        iconR.x = 0;
        textR.height = 0;
        textR.width = 0;
        textR.y = 0;
        textR.x = 0;
        viewR.x = dx;
        viewR.y = dy;
        viewR.width = widthHint - dx;
        viewR.height = Short.MAX_VALUE;
        int gap = icon == null ? 0 : iconTextGap;
        int availTextWidth = hTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
        v.setSize(availTextWidth, 0.0f);
        SwingUtilities.layoutCompoundLabel(c, fm, text, icon, vAlign, hAlign, vTextPosition, hTextPosition, viewR, iconR, textR, iconTextGap);
        int x1 = Math.min(iconR.x, textR.x);
        int x2 = Math.max(iconR.x + iconR.width, textR.x + textR.width);
        int y1 = Math.min(iconR.y, textR.y);
        int y2 = Math.max(iconR.y + iconR.height, textR.y + textR.height);
        Dimension rv = new Dimension(x2 - x1, y2 - y1);
        rv.width += dx;
        rv.height += dy;
        return rv;
    }

    public static Dimension getSize(Component c, int sizeflag) {
        View v;
        if (c == null) {
            return new Dimension(0, 0);
        }
        if (c instanceof JLabel && (v = (View)((JLabel)c).getClientProperty("html")) != null) {
            switch (sizeflag) {
                case 0: {
                    Dimension d = new Dimension(c.getPreferredSize());
                    d.width = 1;
                    return d;
                }
                case 1: {
                    Dimension d = new Dimension(c.getPreferredSize());
                    return d;
                }
                case 2: {
                    Dimension d = new Dimension(10240, 10240);
                    d.width = 1;
                    return d;
                }
            }
        }
        switch (sizeflag) {
            case 0: {
                return new Dimension(c.getMinimumSize());
            }
            case 1: {
                return new Dimension(c.getPreferredSize());
            }
            case 2: {
                return new Dimension(c.getMaximumSize());
            }
        }
        return new Dimension(c.getPreferredSize());
    }

    public static Dimension getValidatedSize(Component c, int sizeflag) {
        return SwingLayoutUtility.getValidatedSizes(c)[sizeflag];
    }

    public static Dimension[] getValidatedSizes(Component c) {
        Dimension[] d = new Dimension[]{SwingLayoutUtility.getSize(c, 0), SwingLayoutUtility.getSize(c, 1), SwingLayoutUtility.getSize(c, 2)};
        if (d[0].width > d[1].width) {
            d[0].width = d[1].width;
        }
        if (d[0].height > d[1].height) {
            d[0].height = d[1].height;
        }
        if (d[2].width < d[1].width) {
            d[2].width = d[1].width;
        }
        if (d[2].height < d[1].height) {
            d[2].height = d[1].height;
        }
        return d;
    }

    public static Dimension[] addPadding(Dimension[] dims, Insets insets) {
        Dimension[] d = new Dimension[dims.length];
        if (insets != null) {
            int i = 0;
            while (i < d.length) {
                d[i] = SwingLayoutUtility.expandSize(dims[i], insets);
                ++i;
            }
        }
        return d;
    }

    public static Dimension expandSize(Dimension d, Insets insets) {
        if (insets != null) {
            d = new Dimension(d.width + insets.left + insets.right, d.height + insets.top + insets.bottom);
        }
        return d;
    }

    public static Rectangle shrinkSize(Rectangle r, Insets insets) {
        if (insets != null) {
            r = new Rectangle(r.x + insets.left, r.y + insets.top, r.width - insets.left - insets.right, r.height - insets.top - insets.bottom);
        }
        if (r.width < 0) {
            r.width = 0;
        }
        if (r.height < 0) {
            r.height = 0;
        }
        return r;
    }

    public static void setIconButtonSizes(ISwingEnvironment env, JComponent c) {
        int w;
        int h = w = env.getIconButtonSize();
        c.setMinimumSize(new Dimension(w, h));
        c.setPreferredSize(new Dimension(w, h));
        c.setMaximumSize(new Dimension(w, h));
    }

    public static void setIconButtonWithPopupSizes(ISwingEnvironment env, JComponent c) {
        int w = env.getDropDownButtonWidth();
        int h = env.getIconButtonSize();
        c.setMinimumSize(new Dimension(w, h));
        c.setPreferredSize(new Dimension(w, h));
        c.setMaximumSize(new Dimension(w, h));
    }

    public static void invalidateAncestors(Component c) {
        if (c != null) {
            do {
                c.invalidate();
            } while ((c = c.getParent()) != null && (!(c instanceof JComponent) || !((JComponent)c).isValidateRoot()));
        }
    }

    public static void invalidateSubtree(Component c) {
        SwingLayoutUtility.invalidateSubtreeRec(c);
    }

    private static void invalidateSubtreeRec(Component c) {
        if (c != null && c.isVisible()) {
            c.invalidate();
            if (c instanceof Container) {
                Component[] componentArray = ((Container)c).getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component child = componentArray[n2];
                    SwingLayoutUtility.invalidateSubtreeRec(child);
                    ++n2;
                }
            }
        }
    }

    public static void dumpSizeTree(Component c) {
        if (!dumpSizeTreeRunning) {
            try {
                dumpSizeTreeRunning = true;
                SwingLayoutUtility.dumpSizeTreeRec(c, "");
            }
            finally {
                dumpSizeTreeRunning = false;
            }
        }
    }

    private static void dumpSizeTreeRec(Component c, String prefix) {
        if (c.isVisible()) {
            LayoutManager layout;
            Object gd;
            LayoutManager lm;
            Dimension[] d = SwingLayoutUtility.getValidatedSizes(c);
            String lay = "null";
            if (c instanceof Container && (lm = ((Container)c).getLayout()) != null) {
                lay = lm.getClass().getSimpleName();
            }
            Rectangle r = c.getBounds();
            StringBuffer buf = new StringBuffer();
            buf.append("[" + r.x + "," + r.y + "," + r.width + "," + r.height + "]");
            buf.append(" min=(" + d[0].width + "," + d[0].height + ")");
            buf.append(" pref=(" + d[1].width + "," + d[1].height + ")");
            buf.append(" max=(" + d[2].width + "," + d[2].height + ")");
            buf.append(" " + c.getClass().getSimpleName() + " " + c.getName());
            buf.append(" layout=" + lay);
            buf.append(" minimumSet=" + c.isMinimumSizeSet());
            buf.append(" preferredSet=" + c.isPreferredSizeSet());
            buf.append(" maximumSet=" + c.isMaximumSizeSet());
            buf.append(" valid=" + c.isValid());
            buf.append(" visible=" + c.isVisible());
            if (c instanceof JComponent && (gd = ((JComponent)c).getClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME)) != null) {
                buf.append(" logicalGridData=" + gd);
            }
            if (c instanceof JComponent && (layout = ((JComponent)c).getLayout()) instanceof LogicalGridLayout) {
                StringWriter w = new StringWriter();
                ((LogicalGridLayout)layout).dumpLayoutInfo((Container)c, new PrintWriter((Writer)w, true));
                buf.append("\n  " + w.toString().replace("\n", "\n  "));
            }
            String msg = String.valueOf(prefix) + buf.toString().replace("\n", "\n" + prefix);
            System.out.println(msg);
            if (c instanceof Container) {
                Component[] componentArray = ((Container)c).getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component child = componentArray[n2];
                    SwingLayoutUtility.dumpSizeTreeRec(child, String.valueOf(prefix) + "  ");
                    ++n2;
                }
            }
        }
    }
}

