/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class SwingPopupWorker
implements Runnable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingPopupWorker.class);
    private ISwingEnvironment m_env;
    private Component m_target;
    private Point m_point;
    private IMenu[] m_scoutMenus;

    public SwingPopupWorker(ISwingEnvironment env, Component target, Point point, IMenu[] scoutMenus) {
        this.m_env = env;
        this.m_target = target;
        this.m_point = point;
        this.m_scoutMenus = scoutMenus;
    }

    @Override
    public void run() {
        if (this.m_scoutMenus == null || this.m_scoutMenus.length == 0) {
            return;
        }
        JPopupMenu pop = new JPopupMenu();
        this.m_env.appendActions(pop, Arrays.asList(this.m_scoutMenus));
        try {
            if (pop.getComponentCount() > 0) {
                Point whereOnTarget = this.m_point;
                if (!this.m_target.isVisible()) {
                    Component visibleAncestor = this.m_target;
                    while (visibleAncestor != null && !visibleAncestor.isVisible()) {
                        visibleAncestor = visibleAncestor.getParent();
                    }
                    whereOnTarget = SwingUtilities.convertPoint(this.m_target, whereOnTarget, visibleAncestor);
                    this.m_target = visibleAncestor;
                }
                Point compLocationOnScreen = this.m_target.getLocationOnScreen();
                Point p = new Point(whereOnTarget);
                p.translate(compLocationOnScreen.x, compLocationOnScreen.y);
                Rectangle r = new Rectangle(p, pop.getPreferredSize());
                Rectangle ownerBounds = new Rectangle(this.m_target.getLocationOnScreen().x, this.m_target.getLocationOnScreen().y, this.m_target.getWidth(), this.m_target.getHeight());
                if (this.m_target.getParent() instanceof JViewport && this.m_target.getParent().getParent() instanceof JScrollPane) {
                    Container scrollpane = this.m_target.getParent().getParent();
                    ownerBounds = new Rectangle(scrollpane.getLocationOnScreen().x, scrollpane.getLocationOnScreen().y, scrollpane.getWidth(), scrollpane.getHeight());
                }
                Rectangle ownerScreen = SwingUtility.getFullScreenBoundsFor(ownerBounds, true);
                r = SwingUtility.validateRectangleOnScreen(r, ownerScreen, true, true);
                if (r.y < ownerBounds.y && r.height > ownerBounds.height) {
                    Rectangle tmp = new Rectangle(r);
                    tmp.y = ownerBounds.y + ownerBounds.height + 2;
                    Rectangle result = SwingUtility.validateRectangleOnScreen(tmp, ownerScreen, true, true);
                    if (result.equals(tmp)) {
                        r = tmp;
                    } else {
                        tmp = new Rectangle(r);
                        tmp.y = ownerBounds.y - pop.getPreferredSize().height - 2;
                        result = SwingUtility.validateRectangleOnScreen(tmp, ownerScreen, true, true);
                        if (result.equals(tmp)) {
                            r = tmp;
                        }
                    }
                }
                p = r.getLocation();
                p.translate(-compLocationOnScreen.x, -compLocationOnScreen.y);
                pop.show(this.m_target, p.x, p.y);
            }
        }
        catch (Exception e) {
            LOG.error(null, (Throwable)e);
        }
    }

    public void enqueue() {
        this.m_env.invokeSwingLater(this);
    }
}

