/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.action;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.ext.JButtonEx;
import org.eclipse.scout.rt.ui.swing.ext.JToggleButtonEx;

public class LegacySwingScoutActionButton<T extends IAction>
extends SwingScoutComposite<T>
implements ISwingScoutAction<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LegacySwingScoutActionButton.class);
    private OptimisticLock m_selectionLock = new OptimisticLock();

    @Override
    protected void initializeSwing() {
        AbstractButton swingButton;
        if (((IAction)this.getScoutObject()).isToggleAction()) {
            swingButton = new JToggleButtonEx();
            swingButton.addItemListener(new P_SwingSelectionListener());
        } else {
            swingButton = new JButtonEx();
        }
        SwingUtility.installDefaultFocusHandling(swingButton);
        swingButton.setMargin(new Insets(8, 4, 8, 4));
        swingButton.setHorizontalTextPosition(4);
        swingButton.setVerifyInputWhenFocusTarget(true);
        swingButton.setRequestFocusEnabled(true);
        this.setSwingField(swingButton);
        swingButton.addActionListener(new P_SwingActionListener());
    }

    @Override
    public Action getSwingAction() {
        return null;
    }

    @Override
    public AbstractButton getSwingField() {
        return (AbstractButton)super.getSwingField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IAction b = (IAction)this.getScoutObject();
        this.setVisibleFromScout(b.isVisible());
        this.setEnabledFromScout(b.isEnabled());
        this.setTextFromScout(b.getText());
        this.setTooltipTextFromScout(b.getTooltipText());
        this.setIconIdFromScout(b.getIconId());
        this.setSelectionFromScout(b.isSelected());
    }

    protected void setIconIdFromScout(String s) {
        if (s != null) {
            AbstractButton b = this.getSwingField();
            Icon icon = this.getSwingEnvironment().getIcon(s);
            b.setIcon(icon);
            Icon pressedIcon = this.getSwingEnvironment().getIcon(String.valueOf(s) + "_pressed");
            Icon rolloverIcon = this.getSwingEnvironment().getIcon(String.valueOf(s) + "_rollover");
            Icon disabledIcon = this.getSwingEnvironment().getIcon(String.valueOf(s) + "_disabled");
            if (pressedIcon != null && rolloverIcon != null && disabledIcon != null) {
                b.setRolloverEnabled(true);
                b.setMargin(null);
                b.setBorder(null);
                b.setBorderPainted(false);
                b.setFocusPainted(false);
                b.setPressedIcon(pressedIcon);
                b.setSelectedIcon(pressedIcon);
                b.setRolloverIcon(rolloverIcon);
                b.setDisabledIcon(disabledIcon);
            }
        }
    }

    protected void setTextFromScout(String s) {
        AbstractButton b = this.getSwingField();
        String label = StringUtility.removeMnemonic((String)s);
        b.setText(label);
        if (StringUtility.getMnemonic((String)s) != '\u0000') {
            b.setMnemonic(StringUtility.getMnemonic((String)s));
        }
    }

    protected void setVisibleFromScout(boolean b) {
        this.getSwingField().setVisible(b);
    }

    protected void setEnabledFromScout(boolean b) {
        this.getSwingField().setEnabled(b);
    }

    protected void setSelectionFromScout(boolean b) {
        try {
            if (this.m_selectionLock.acquire()) {
                this.getSwingField().setSelected(b);
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    protected void setTooltipTextFromScout(String s) {
        this.getSwingField().setToolTipText(s);
    }

    protected void setSelectionFromSwing(final boolean b) {
        try {
            if (this.m_selectionLock.acquire() && ((IAction)this.getScoutObject()).isSelected() != b) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((IAction)LegacySwingScoutActionButton.this.getScoutObject()).getUIFacade().setSelectedFromUI(b);
                    }
                };
                this.getSwingEnvironment().invokeScoutLater(t, 0L);
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("enabled")) {
            this.setEnabledFromScout((Boolean)newValue);
        } else if (name.equals("text")) {
            this.setTextFromScout((String)newValue);
        } else if (name.equals("tooltipText")) {
            this.setTooltipTextFromScout((String)newValue);
        } else if (name.equals("visible")) {
            this.setVisibleFromScout((Boolean)newValue);
        } else if (name.equals("iconId")) {
            this.setIconIdFromScout((String)newValue);
        } else if (name.equals("selected")) {
            this.setSelectionFromScout((Boolean)newValue);
        }
    }

    protected void handleSwingAction(ActionEvent e) {
        if (!this.getSwingField().isFocusable() || this.getSwingField().isFocusOwner()) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IAction)LegacySwingScoutActionButton.this.getScoutObject()).getUIFacade().fireActionFromUI();
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private class P_SwingActionListener
    implements ActionListener {
        private P_SwingActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LegacySwingScoutActionButton.this.handleSwingAction(e);
        }
    }

    private class P_SwingSelectionListener
    implements ItemListener {
        private P_SwingSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            LegacySwingScoutActionButton.this.setSelectionFromSwing(LegacySwingScoutActionButton.this.getSwingField().isSelected());
        }
    }
}

