/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.action;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJTab;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.JToolTab;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.JViewTab;

public class SwingScoutActionButton<T extends IAction>
extends SwingScoutComposite<T>
implements ISwingScoutAction<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutActionButton.class);
    private boolean m_handleActionPending;

    @Override
    protected void initializeSwing() {
        AbstractJTab swingButton = this.getScoutObject() instanceof IViewButton ? new JViewTab(this.getSwingEnvironment()) : new JToolTab(this.getSwingEnvironment());
        SwingUtility.installDefaultFocusHandling(swingButton);
        swingButton.setMargin(new Insets(8, 4, 8, 4));
        swingButton.setHorizontalTextPosition(4);
        swingButton.setVerifyInputWhenFocusTarget(true);
        swingButton.setRequestFocusEnabled(true);
        this.setSwingField(swingButton);
        swingButton.addActionListener(new P_SwingActionListener());
        swingButton.addItemListener(new P_SwingSelectionListener());
    }

    @Override
    public Action getSwingAction() {
        return null;
    }

    @Override
    public AbstractButton getSwingField() {
        return (AbstractButton)super.getSwingField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IAction b = (IAction)this.getScoutObject();
        this.setVisibleFromScout(b.isVisible());
        this.setEnabledFromScout(b.isEnabled());
        this.setTextFromScout(b.getText());
        this.setTooltipTextFromScout(b.getTooltipText());
        this.setIconIdFromScout(b.getIconId());
        this.setSelectionFromScout(b.isSelected());
    }

    protected void setIconIdFromScout(String iconId) {
        if (iconId != null) {
            AbstractJTab b = (AbstractJTab)this.getSwingField();
            b.setIconGroupById(iconId);
        }
    }

    protected void setTextFromScout(String s) {
        AbstractButton b = this.getSwingField();
        String label = StringUtility.removeMnemonic((String)s);
        b.setText(label);
        if (StringUtility.getMnemonic((String)s) != '\u0000') {
            b.setMnemonic(StringUtility.getMnemonic((String)s));
        }
    }

    protected void setVisibleFromScout(boolean b) {
        this.getSwingField().setVisible(b);
    }

    protected void setEnabledFromScout(boolean b) {
        this.getSwingField().setEnabled(b);
    }

    protected void setSelectionFromScout(boolean b) {
        this.getSwingField().setSelected(b);
    }

    protected void setTooltipTextFromScout(String s) {
        s = SwingUtility.createHtmlLabelText(s, true);
        if (this.getSwingField() != null) {
            this.getSwingField().setToolTipText(s);
        }
    }

    protected void setSelectionFromSwing(final boolean b) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IAction)SwingScoutActionButton.this.getScoutObject()).getUIFacade().setSelectedFromUI(b);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("enabled")) {
            this.setEnabledFromScout((Boolean)newValue);
        } else if (name.equals("text")) {
            this.setTextFromScout((String)newValue);
        } else if (name.equals("tooltipText")) {
            this.setTooltipTextFromScout((String)newValue);
        } else if (name.equals("visible")) {
            this.setVisibleFromScout((Boolean)newValue);
        } else if (name.equals("iconId")) {
            this.setIconIdFromScout((String)newValue);
        } else if (name.equals("selected")) {
            this.setSelectionFromScout((Boolean)newValue);
        }
    }

    protected void handleSwingAction(ActionEvent e) {
        if (SwingUtility.runInputVerifier() && !this.m_handleActionPending) {
            this.m_handleActionPending = true;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        ((IAction)SwingScoutActionButton.this.getScoutObject()).getUIFacade().fireActionFromUI();
                    }
                    finally {
                        SwingScoutActionButton.this.m_handleActionPending = false;
                    }
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private class P_SwingActionListener
    implements ActionListener {
        private P_SwingActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutActionButton.this.handleSwingAction(e);
        }
    }

    private class P_SwingSelectionListener
    implements ItemListener {
        private P_SwingSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SwingScoutActionButton.this.setSelectionFromSwing(SwingScoutActionButton.this.getSwingField().isSelected());
        }
    }
}

