/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic;

import java.awt.Component;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;

public class SwingScoutModelFinder {
    public Object getScoutModel(Component comp) {
        Component c = comp;
        if (c == null) {
            return null;
        }
        IPropertyObserver s = null;
        Component tmp = c;
        while (tmp != null) {
            if (tmp instanceof JComponent && (s = SwingScoutComposite.getScoutModelOnWidget((JComponent)tmp)) != null) break;
            tmp = tmp.getParent();
        }
        if (s != null) {
            Object scoutObject = s;
            while (scoutObject != null) {
                if (scoutObject instanceof IFormField || scoutObject instanceof IForm || scoutObject instanceof IAction) break;
                int nestedCount = scoutObject.getClass().getName().replaceAll("[^$]", "").trim().length();
                try {
                    Field f = scoutObject.getClass().getDeclaredField("this$" + (nestedCount - 1));
                    f.setAccessible(true);
                    scoutObject = f.get(scoutObject);
                    break;
                }
                catch (Throwable throwable) {
                    scoutObject = null;
                }
            }
            if (scoutObject != null) {
                return scoutObject;
            }
            return s;
        }
        return null;
    }

    public String getScoutModelName(Component comp) {
        Object scoutModel = this.getScoutModel(comp);
        if (scoutModel != null) {
            String className = scoutModel.getClass().getName();
            String packagePrefix = String.valueOf(scoutModel.getClass().getPackage().getName()) + ".";
            return StringUtility.removePrefixes((String)className, (String[])new String[]{packagePrefix});
        }
        return null;
    }
}

