/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.RepaintManager;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.PrintDevice;

public class WidgetPrinter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(WidgetPrinter.class);
    private Component m_widget;
    private File m_printedFile;

    public WidgetPrinter(Component comp) {
        this.m_widget = comp;
    }

    public File getOutputFile() {
        return this.m_printedFile;
    }

    public void print(PrintDevice device, Map<String, Object> parameters) throws Throwable {
        if (device == PrintDevice.Printer) {
            this.printToPrinter(parameters);
        } else if (device == PrintDevice.File) {
            this.printToFile(parameters);
        }
    }

    private void printToPrinter(Map<String, Object> parameters) throws Throwable {
        String cfr_ignored_0 = (String)parameters.remove("printerName");
        String jobName = (String)parameters.remove("jobName");
        for (String n : parameters.keySet()) {
            LOG.warn("Unknown parameter: " + n + "=" + parameters.get(n));
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setJobName(jobName != null ? jobName : "Widget Screenshot");
        if (job.printDialog()) {
            job.setPrintable(new DefaultPrintable());
            job.print();
        }
    }

    private void printToFile(Map<String, Object> parameters) throws Throwable {
        this.m_printedFile = (File)parameters.remove("file");
        if (this.m_printedFile == null) {
            throw new IllegalArgumentException("parameter \"file\" must not be null");
        }
        String contentType = (String)parameters.remove("contentType");
        if (contentType == null) {
            contentType = "image/jpg";
        }
        if (!contentType.startsWith("image/")) {
            throw new IllegalArgumentException("only supporting contentTypes image/*");
        }
        for (String n : parameters.keySet()) {
            LOG.warn("Unknown parameter: " + n + "=" + parameters.get(n));
        }
        this.m_printedFile.getParentFile().mkdirs();
        BufferedImage img = this.createBufferedImage();
        String imageFormat = contentType.substring(contentType.indexOf("/") + 1);
        boolean ok = ImageIO.write((RenderedImage)img, imageFormat, this.m_printedFile);
        if (!ok) {
            throw new IOException("no appropriate writer was found for imageFormat \"" + imageFormat + "\"");
        }
    }

    private BufferedImage createBufferedImage() {
        BufferedImage img = new BufferedImage(this.m_widget.getWidth(), this.m_widget.getHeight(), 5);
        Graphics gOff = img.getGraphics();
        gOff.setColor(Color.white);
        gOff.fillRect(0, 0, this.m_widget.getWidth(), this.m_widget.getHeight());
        try {
            RepaintManager.currentManager(this.m_widget).setDoubleBufferingEnabled(false);
            this.m_widget.printAll(gOff);
        }
        finally {
            RepaintManager.currentManager(this.m_widget).setDoubleBufferingEnabled(true);
        }
        gOff.dispose();
        return img;
    }

    private class DefaultPrintable
    implements Printable,
    ImageObserver {
        private DefaultPrintable() {
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex > 0) {
                return 1;
            }
            BufferedImage img = WidgetPrinter.this.createBufferedImage();
            Graphics2D g2d = (Graphics2D)g;
            Rectangle pageRect = g2d.getClipBounds();
            Dimension compSize = WidgetPrinter.this.m_widget.getSize();
            double scaleX = 1.0 * (double)pageRect.width / (double)Math.max(1, compSize.width);
            double scaleY = 1.0 * (double)pageRect.height / (double)Math.max(1, compSize.height);
            double scaleProp = Math.min(scaleX, scaleY);
            g2d.translate(pageRect.x, pageRect.y);
            g2d.scale(scaleProp, scaleProp);
            g2d.drawImage((Image)img, 0, 0, this);
            g2d.scale(1.0 / scaleProp, 1.0 / scaleProp);
            g2d.translate(-pageRect.x, -pageRect.y);
            return 0;
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            return (infoflags & 0x30) != 0;
        }
    }
}

