/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.calendar;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarModel;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarViewEvent;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarViewListener;
import org.eclipse.scout.rt.ui.swing.ext.calendar.DateChooser;

public class SwingScoutCalendar
extends SwingScoutComposite<ICalendar> {
    private DateChooser m_dateChooser;

    @Override
    protected void initializeSwing() {
        this.m_dateChooser = new DateChooser(true);
        JPanel container = this.m_dateChooser.getContainer();
        SwingUtility.installDefaultFocusHandling(container);
        this.setSwingField(container);
        container.addMouseListener(new P_SwingCalendarMouseListener());
        this.m_dateChooser.addCalendarViewListener(new P_SwingCalendarListener());
        container.getInputMap(2).put(SwingUtility.createKeystroke("F5"), "refresh");
        container.getActionMap().put("refresh", new P_SwingRefreshAction());
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        final Date minDate = this.m_dateChooser.getViewDateStart();
        final Date maxDate = this.m_dateChooser.getViewDateEnd();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().setVisibleRangeFromUI(minDate, maxDate);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
        this.setSetupFromScout(((ICalendar)this.getScoutObject()).getDisplayMode(), ((ICalendar)this.getScoutObject()).isDisplayCondensed());
        this.setCalendarComponentsFromScout(((ICalendar)this.getScoutObject()).getComponents());
        this.setSelectionFromScout(((ICalendar)this.getScoutObject()).getSelectedDate(), ((ICalendar)this.getScoutObject()).getSelectedComponent());
    }

    public DateChooser getDateChooser() {
        return this.m_dateChooser;
    }

    private void setSetupFromScout(int mode, boolean condensed) {
        this.getDateChooser().setDisplayMode(mode);
    }

    private void setSelectionFromScout(Date d, CalendarComponent cc) {
        this.getDateChooser().setDate(d);
    }

    private void setLoadInProgressFromScout(boolean b) {
        if (b) {
            this.getSwingField().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.getSwingField().setCursor(null);
        }
    }

    protected void setCalendarComponentsFromScout(CalendarComponent[] c) {
        this.getDateChooser().setModel(new P_SwingCalendarModel(c));
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("selectedDate") || name.equals("selectedComponent")) {
            this.setSelectionFromScout(((ICalendar)this.getScoutObject()).getSelectedDate(), ((ICalendar)this.getScoutObject()).getSelectedComponent());
        } else if (name.equals("components")) {
            this.setCalendarComponentsFromScout((CalendarComponent[])newValue);
        } else if (name.equals("loadInProgress")) {
            this.setLoadInProgressFromScout((Boolean)newValue);
        } else if (name.equals("displayMode") || name.equals("displayCondensed")) {
            this.setSetupFromScout(((ICalendar)this.getScoutObject()).getDisplayMode(), ((ICalendar)this.getScoutObject()).isDisplayCondensed());
        }
    }

    private void handleSwingCalendarPopup(final MouseEvent e) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        CalendarComponent item = (CalendarComponent)this.getDateChooser().getCalendarItemFor(e);
        if (item != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    IMenu[] scoutMenus = ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().fireComponentPopupFromUI();
                    new SwingPopupWorker(SwingScoutCalendar.this.getSwingEnvironment(), e.getComponent(), e.getPoint(), scoutMenus).enqueue();
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 5678L);
        } else {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    IMenu[] scoutMenus = ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().fireNewPopupFromUI();
                    new SwingPopupWorker(SwingScoutCalendar.this.getSwingEnvironment(), e.getComponent(), e.getPoint(), scoutMenus).enqueue();
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 5678L);
        }
    }

    private void handleSwingCalendarItemAction(MouseEvent e) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().fireComponentActionFromUI();
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    private class P_SwingCalendarListener
    implements CalendarViewListener {
        private P_SwingCalendarListener() {
        }

        @Override
        public void viewChanged(CalendarViewEvent e) {
            switch (e.getType()) {
                case 30: {
                    if (SwingScoutCalendar.this.getUpdateSwingFromScoutLock().isAcquired()) {
                        return;
                    }
                    final Date d = SwingScoutCalendar.this.getDateChooser().getDate();
                    final CalendarComponent cc = (CalendarComponent)SwingScoutCalendar.this.getDateChooser().getSelectedItem();
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().setSelectionFromUI(d, cc);
                        }
                    };
                    SwingScoutCalendar.this.getSwingEnvironment().invokeScoutLater(t, 0L);
                    break;
                }
                case 20: {
                    if (SwingScoutCalendar.this.getUpdateSwingFromScoutLock().isAcquired()) {
                        return;
                    }
                    final int m = SwingScoutCalendar.this.getDateChooser().getDisplayMode();
                    final Date minDate = SwingScoutCalendar.this.getDateChooser().getViewDateStart();
                    final Date maxDate = SwingScoutCalendar.this.getDateChooser().getViewDateEnd();
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            ((ICalendar)SwingScoutCalendar.this.getScoutObject()).setDisplayMode(m);
                            ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().setVisibleRangeFromUI(minDate, maxDate);
                        }
                    };
                    SwingScoutCalendar.this.getSwingEnvironment().invokeScoutLater(t, 0L);
                    break;
                }
                case 10: {
                    final Date minDate = SwingScoutCalendar.this.getDateChooser().getViewDateStart();
                    final Date maxDate = SwingScoutCalendar.this.getDateChooser().getViewDateEnd();
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().setVisibleRangeFromUI(minDate, maxDate);
                        }
                    };
                    SwingScoutCalendar.this.getSwingEnvironment().invokeScoutLater(t, 0L);
                }
            }
        }
    }

    private class P_SwingCalendarModel
    implements CalendarModel {
        private CalendarComponent[] m_components;
        private HashMap<Date, Collection<Object>> m_dayMap;

        public P_SwingCalendarModel(CalendarComponent[] components) {
            this.m_components = components;
            this.m_dayMap = new HashMap();
            CalendarComponent[] calendarComponentArray = this.m_components;
            int n = this.m_components.length;
            int n2 = 0;
            while (n2 < n) {
                CalendarComponent comp = calendarComponentArray[n2];
                Date[] dateArray = comp.getCoveredDays();
                int n3 = dateArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Date day = dateArray[n4];
                    Collection<Object> list = this.m_dayMap.get(day);
                    if (list == null) {
                        list = new ArrayList<Object>();
                        this.m_dayMap.put(day, list);
                    }
                    list.add(comp);
                    ++n4;
                }
                ++n2;
            }
        }

        @Override
        public Collection<Object> getItemsAt(Date dateTruncatedToDay) {
            return this.m_dayMap.get(dateTruncatedToDay);
        }

        @Override
        public String getTooltip(Object item, Date d) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.getTooltip(d);
        }

        @Override
        public String getLabel(Object item, Date d) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.getLabel(d);
        }

        @Override
        public Date getFromDate(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.getFromDate();
        }

        @Override
        public Date getToDate(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.getToDate();
        }

        @Override
        public Color getColor(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return SwingUtility.createColor(comp.getCell().getBackgroundColor());
        }

        @Override
        public boolean isFullDay(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.isFullDay();
        }

        @Override
        public boolean isDraggable(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.isDraggable();
        }

        @Override
        public void moveItem(final Object item, final Date newDate) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    CalendarComponent comp = (CalendarComponent)item;
                    ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().fireComponentMovedFromUI(comp, newDate);
                }
            };
            SwingScoutCalendar.this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private class P_SwingCalendarMouseListener
    extends MouseAdapter {
        MouseClickedBugFix fix;

        private P_SwingCalendarMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.fix = new MouseClickedBugFix(e);
            if (e.isPopupTrigger()) {
                SwingScoutCalendar.this.handleSwingCalendarPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SwingScoutCalendar.this.handleSwingCalendarPopup(e);
            }
            if (this.fix != null) {
                this.fix.mouseReleased(this, e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.fix.mouseClicked()) {
                return;
            }
            if (!e.isPopupTrigger() && e.getClickCount() >= 2) {
                SwingScoutCalendar.this.handleSwingCalendarItemAction(e);
            }
        }
    }

    private class P_SwingRefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_SwingRefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SwingScoutCalendar.this.getUpdateSwingFromScoutLock().isAcquired()) {
                return;
            }
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().fireReloadFromUI();
                }
            };
            SwingScoutCalendar.this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }
}

