/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.document;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.window.SwingWindowManager;

public class BasicDocumentFilter
extends DocumentFilter {
    private static final long serialVersionUID = 1L;
    private int m_maxLen;

    public BasicDocumentFilter() {
    }

    public BasicDocumentFilter(int maxLength) {
        this.m_maxLen = maxLength;
    }

    public int getMaxLength() {
        return this.m_maxLen;
    }

    public void setMaxLength(int maxLen) {
        this.m_maxLen = maxLen;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String s, AttributeSet a) throws BadLocationException {
        int newLen;
        if (s == null) {
            s = "";
        }
        Document doc = fb.getDocument();
        if (this.m_maxLen > 0 && (newLen = doc.getLength() + s.length()) > this.m_maxLen) {
            s = this.handleStringTooLong(s, Math.max(0, s.length() - (newLen - this.m_maxLen)));
        }
        fb.insertString(offset, s, a);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String s, AttributeSet a) throws BadLocationException {
        int newLen;
        if (s == null) {
            s = "";
        }
        Document doc = fb.getDocument();
        if (this.m_maxLen > 0 && (newLen = doc.getLength() + s.length() - length) > this.m_maxLen) {
            s = this.handleStringTooLong(s, Math.max(0, s.length() - (newLen - this.m_maxLen)));
        }
        fb.replace(offset, length, s, a);
    }

    protected String handleStringTooLong(String s, int availableLength) throws BadLocationException {
        if (SwingUtility.isPasteAction() || SwingUtility.isSunDropAction()) {
            SwingUtility.showMessageDialogSynthCapable(SwingWindowManager.getInstance().getActiveWindow(), SwingUtility.getNlsText("PasteTextTooLongForFieldX", "" + this.getMaxLength()), SwingUtility.getNlsText("Paste", new String[0]), 2);
        }
        s = s.substring(0, availableLength);
        return s;
    }
}

