/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swing.SingleLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.ISwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.basic.table.ISwingScoutTable;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTableEx;
import org.eclipse.scout.rt.ui.swing.focus.SwingScoutFocusTraversalPolicy;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;

public class SwingScoutTableCellEditor {
    public static final String TABLE_CELL_INSETS = String.valueOf(SwingScoutTableCellEditor.class.getName()) + "#insets";
    private ISwingScoutTable m_tableComposite;
    private FocusTraversalPolicy m_focusTraversalPolicy;
    private TableCellEditor m_cellEditor;
    private boolean m_tableIsEditingAndContainsFocus;
    private JComponent m_cachedSwingEditorComponent;

    public SwingScoutTableCellEditor(ISwingScoutTable tableComposite) {
        this.m_tableComposite = tableComposite;
        this.m_focusTraversalPolicy = new SwingScoutFocusTraversalPolicy();
        this.m_cellEditor = new P_SwingCellEditor();
        this.m_cellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                SwingScoutTableCellEditor.this.saveEditorFromSwing();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                SwingScoutTableCellEditor.this.cancelEditorFromSwing();
            }
        });
    }

    public void initialize() {
        this.m_tableComposite.getSwingTable().setDefaultEditor(Object.class, this.m_cellEditor);
    }

    protected JComponent getCachedEditorComposite(int row, int col) {
        ISwingScoutComposite<? extends IFormField> editorComposite;
        if (this.m_cachedSwingEditorComponent == null && (editorComposite = this.createEditorComposite(row, col)) != null) {
            this.decorateEditorComposite(editorComposite, row, col);
            this.m_cachedSwingEditorComponent = editorComposite.getSwingContainer();
        }
        return this.m_cachedSwingEditorComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISwingScoutComposite<? extends IFormField> createEditorComposite(int row, int col) {
        final ITableRow scoutRow = ((ITable)this.m_tableComposite.getScoutObject()).getFilteredRow(row);
        final IColumn scoutColumn = ((ITable)this.m_tableComposite.getScoutObject()).getColumnSet().getVisibleColumn(col);
        final AtomicReference fieldRef = new AtomicReference();
        if (scoutRow != null && scoutColumn != null) {
            Runnable t = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    fieldRef.set(((ITable)SwingScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().prepareCellEditFromUI(scoutRow, scoutColumn));
                    AtomicReference atomicReference = fieldRef;
                    synchronized (atomicReference) {
                        fieldRef.notifyAll();
                    }
                }
            };
            AtomicReference atomicReference = fieldRef;
            synchronized (atomicReference) {
                this.m_tableComposite.getSwingEnvironment().invokeScoutLater(t, 2345L);
                try {
                    fieldRef.wait(2345L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (fieldRef.get() != null) {
            if (scoutColumn instanceof IBooleanColumn) {
                GridData gd = ((IFormField)fieldRef.get()).getGridDataHints();
                gd.verticalAlignment = ((IBooleanColumn)scoutColumn).getVerticalAlignment();
                gd.horizontalAlignment = scoutColumn.getHorizontalAlignment();
                ((IFormField)fieldRef.get()).setGridDataHints(gd);
            }
            Insets cellInsets = new Insets(0, 0, 0, 0);
            TableCellRenderer cellRenderer = this.m_tableComposite.getSwingTable().getCellRenderer(row, col);
            cellRenderer = (TableCellRenderer)((Object)this.m_tableComposite.getSwingTable().prepareRenderer(cellRenderer, row, col));
            if (cellRenderer instanceof DefaultTableCellRenderer) {
                cellInsets = ((DefaultTableCellRenderer)cellRenderer).getInsets();
            }
            this.m_tableComposite.getSwingTable().putClientProperty(TABLE_CELL_INSETS, cellInsets);
            try {
                ISwingScoutFormField iSwingScoutFormField = this.m_tableComposite.getSwingEnvironment().createFormField(this.m_tableComposite.getSwingTable(), (IFormField)fieldRef.get());
                return iSwingScoutFormField;
            }
            finally {
                this.m_tableComposite.getSwingTable().putClientProperty(TABLE_CELL_INSETS, null);
            }
        }
        return null;
    }

    protected void decorateEditorComposite(ISwingScoutComposite<? extends IFormField> editorComposite, final int row, final int col) {
        JComponent jc;
        JComponent editorField = editorComposite.getSwingContainer();
        Component firstField = this.m_focusTraversalPolicy.getFirstComponent(editorField);
        Component lastField = this.m_focusTraversalPolicy.getLastComponent(editorField);
        if (firstField != null) {
            firstField.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(final HierarchyEvent e) {
                    if (e.getID() == 1400 && (e.getChangeFlags() & 4L) != 0L && e.getComponent().isShowing()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                e.getComponent().requestFocus();
                            }
                        });
                    }
                }
            });
        }
        if (firstField instanceof JComponent) {
            jc = (JComponent)firstField;
            jc.setFocusTraversalKeys(1, new HashSet());
            jc.getInputMap(0).put(SwingUtility.createKeystroke("shift TAB"), "reverse-tab");
            jc.getActionMap().put("reverse-tab", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutTableCellEditor.this.m_cellEditor.stopCellEditing();
                    SwingScoutTableCellEditor.this.editPreviousTableCell(row, col);
                }
            });
        }
        if (lastField instanceof JComponent) {
            jc = (JComponent)lastField;
            jc.setFocusTraversalKeys(0, new HashSet());
            jc.getInputMap(0).put(SwingUtility.createKeystroke("TAB"), "tab");
            jc.getActionMap().put("tab", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutTableCellEditor.this.m_cellEditor.stopCellEditing();
                    SwingScoutTableCellEditor.this.editNextTableCell(row, col);
                }
            });
        }
    }

    protected void saveEditorFromSwing() {
        this.m_tableIsEditingAndContainsFocus = false;
        if (this.m_cachedSwingEditorComponent != null) {
            this.m_cachedSwingEditorComponent = null;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)SwingScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().completeCellEditFromUI();
                }
            };
            this.m_tableComposite.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void cancelEditorFromSwing() {
        this.m_tableIsEditingAndContainsFocus = false;
        if (this.m_cachedSwingEditorComponent != null) {
            this.m_cachedSwingEditorComponent = null;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)SwingScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().cancelCellEditFromUI();
                }
            };
            this.m_tableComposite.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void editNextTableCell(int row, int col) {
        JTableEx table = this.m_tableComposite.getSwingTable();
        if (row >= 0 && col >= 0) {
            int rowCount = table.getRowCount();
            int colCount = table.getColumnCount();
            int a = rowCount + colCount;
            while (a > 1) {
                --a;
                if (++col >= colCount) {
                    ++row;
                    col = 0;
                }
                if (row >= rowCount) {
                    row = 0;
                }
                if (!table.isCellEditable(row, col)) continue;
                table.getSelectionModel().setSelectionInterval(row, row);
                table.getColumnModel().getSelectionModel().setSelectionInterval(col, col);
                table.scrollRectToVisible(((JTable)table).getCellRect(row, col, true));
                table.editCellAt(row, col);
                return;
            }
        }
    }

    protected void editPreviousTableCell(int row, int col) {
        JTableEx table = this.m_tableComposite.getSwingTable();
        if (row >= 0 && col >= 0) {
            int rowCount = table.getRowCount();
            int colCount = table.getColumnCount();
            int a = rowCount + colCount;
            while (a > 1) {
                --a;
                if (--col < 0) {
                    --row;
                    col = colCount - 1;
                }
                if (row < 0) {
                    row = rowCount - 1;
                }
                if (!table.isCellEditable(row, col)) continue;
                table.getSelectionModel().setSelectionInterval(row, row);
                table.getColumnModel().getSelectionModel().setSelectionInterval(col, col);
                table.scrollRectToVisible(((JTable)table).getCellRect(row, col, true));
                table.editCellAt(row, col);
                return;
            }
        }
    }

    protected void permanentFocusOwnerChanged(PropertyChangeEvent e) {
        boolean newValue;
        Component c = (Component)e.getNewValue();
        if (c == null) {
            return;
        }
        boolean oldValue = this.m_tableIsEditingAndContainsFocus;
        this.m_tableIsEditingAndContainsFocus = newValue = SwingUtilities.isDescendingFrom(c, this.m_tableComposite.getSwingTable()) && c != this.m_tableComposite.getSwingTable();
        if (oldValue && !newValue && this.m_cellEditor != null) {
            this.m_cellEditor.stopCellEditing();
        }
    }

    private static class GlobalFocusListener
    implements PropertyChangeListener {
        private WeakReference<SwingScoutTableCellEditor> m_editorRef;

        public GlobalFocusListener(SwingScoutTableCellEditor editor) {
            this.m_editorRef = new WeakReference<SwingScoutTableCellEditor>(editor);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            SwingScoutTableCellEditor editor = (SwingScoutTableCellEditor)this.m_editorRef.get();
            if (editor == null) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this);
                return;
            }
            editor.permanentFocusOwnerChanged(e);
        }
    }

    private class P_SwingCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private int m_clickCountToStart = 1;
        private JPanelEx m_container = new JPanelEx(new SingleLayout());

        public P_SwingCellEditor() {
            this.m_container.setOpaque(false);
            this.m_container.getInputMap(1).put(SwingUtility.createKeystroke("ESCAPE"), "cancel");
            this.m_container.getInputMap(1).put(SwingUtility.createKeystroke("ENTER"), "enter");
            this.m_container.getActionMap().put("cancel", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutTableCellEditor.this.m_cellEditor.cancelCellEditing();
                }
            });
            this.m_container.getActionMap().put("enter", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutTableCellEditor.this.m_cellEditor.stopCellEditing();
                }
            });
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", new GlobalFocusListener(SwingScoutTableCellEditor.this));
        }

        public void setClickCountToStart(int count) {
            this.m_clickCountToStart = count;
        }

        public int getClickCountToStart() {
            return this.m_clickCountToStart;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= this.getClickCountToStart();
            }
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.m_container.removeAll();
            JComponent c = SwingScoutTableCellEditor.this.getCachedEditorComposite(row, column);
            if (c != null) {
                this.m_container.add(c);
            }
            return this.m_container;
        }
    }
}

