/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingScoutTable;

public class SwingTableModel
extends AbstractTableModel {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingTableModel.class);
    private static final long serialVersionUID = 1L;
    private ISwingEnvironment m_env;
    private SwingScoutTable m_swingScoutTable;
    private int m_rowCount;

    public SwingTableModel(ISwingEnvironment env, SwingScoutTable swingScoutTable) {
        this.m_env = env;
        this.m_swingScoutTable = swingScoutTable;
        ITable table = (ITable)this.m_swingScoutTable.getScoutObject();
        this.m_rowCount = table != null ? table.getFilteredRowCount() : 0;
    }

    @Override
    public int getRowCount() {
        return this.m_rowCount;
    }

    @Override
    public int getColumnCount() {
        ITable table = (ITable)this.m_swingScoutTable.getScoutObject();
        return table != null ? table.getVisibleColumnCount() : 0;
    }

    @Override
    public String getColumnName(int col) {
        return null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        ITable table = (ITable)this.m_swingScoutTable.getScoutObject();
        if (table != null) {
            ITableRow scoutRow = table.getFilteredRow(row);
            try {
                ICell visibleCell = table.getVisibleCell(scoutRow, col);
                return visibleCell;
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int colIndex) {
    }

    @Override
    public boolean isCellEditable(int x, int y) {
        ITable table = (ITable)this.m_swingScoutTable.getScoutObject();
        if (table == null) {
            return false;
        }
        ITableRow row = table.getFilteredRow(x);
        IColumn column = table.getColumnSet().getVisibleColumn(y);
        if (row == null || column == null) {
            return false;
        }
        return table.getCell(row, column).isEditable();
    }

    public void updateModelState(int newRowCount) {
        int oldRowCount = this.m_rowCount;
        this.m_rowCount = newRowCount;
        if (oldRowCount != 0 || newRowCount != 0) {
            if (oldRowCount < newRowCount) {
                this.fireTableChanged(new TableModelEvent(this, oldRowCount, newRowCount - 1, -1, 1));
                this.fireTableChanged(new TableModelEvent(this, 0, oldRowCount - 1, -1, 0));
            } else if (oldRowCount > newRowCount) {
                this.fireTableChanged(new TableModelEvent(this, newRowCount, oldRowCount - 1, -1, -1));
                this.fireTableChanged(new TableModelEvent(this, 0, newRowCount - 1, -1, 0));
            } else {
                this.fireTableChanged(new TableModelEvent(this, 0, newRowCount - 1, -1, 0));
            }
        }
    }
}

