/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.Serializable;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.UIResource;
import org.eclipse.scout.rt.ui.swing.dnd.TransferHandlerEx;

public class DefaultDropTarget
extends DropTarget
implements UIResource {
    private static final long serialVersionUID = 1L;
    private EventListenerList m_eventListenerList;

    public DefaultDropTarget(JComponent c) {
        this.setComponent(c);
        try {
            super.addDropTargetListener(new P_DefaultDropHandler());
        }
        catch (TooManyListenersException tooManyListenersException) {}
    }

    @Override
    public void addDropTargetListener(DropTargetListener listener) throws TooManyListenersException {
        if (this.m_eventListenerList == null) {
            this.m_eventListenerList = new EventListenerList();
        }
        this.m_eventListenerList.add(DropTargetListener.class, listener);
    }

    @Override
    public void removeDropTargetListener(DropTargetListener listener) {
        if (this.m_eventListenerList != null) {
            this.m_eventListenerList.remove(DropTargetListener.class, listener);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
        super.dragEnter(evt);
        if (this.m_eventListenerList != null) {
            Object[] dropTargetListeners = this.m_eventListenerList.getListenerList();
            int k = dropTargetListeners.length - 2;
            while (k >= 0) {
                if (dropTargetListeners[k] == DropTargetListener.class) {
                    ((DropTargetListener)dropTargetListeners[k + 1]).dragEnter(evt);
                }
                k -= 2;
            }
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
        super.dragOver(evt);
        if (this.m_eventListenerList != null) {
            Object[] dropTargetListeners = this.m_eventListenerList.getListenerList();
            int k = dropTargetListeners.length - 2;
            while (k >= 0) {
                if (dropTargetListeners[k] == DropTargetListener.class) {
                    ((DropTargetListener)dropTargetListeners[k + 1]).dragOver(evt);
                }
                k -= 2;
            }
        }
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
        super.dragExit(evt);
        if (this.m_eventListenerList != null) {
            Object[] dropTargetListeners = this.m_eventListenerList.getListenerList();
            int k = dropTargetListeners.length - 2;
            while (k >= 0) {
                if (dropTargetListeners[k] == DropTargetListener.class) {
                    ((DropTargetListener)dropTargetListeners[k + 1]).dragExit(evt);
                }
                k -= 2;
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        super.drop(evt);
        if (this.m_eventListenerList != null) {
            Object[] dropTargetListeners = this.m_eventListenerList.getListenerList();
            int k = dropTargetListeners.length - 2;
            while (k >= 0) {
                if (dropTargetListeners[k] == DropTargetListener.class) {
                    ((DropTargetListener)dropTargetListeners[k + 1]).drop(evt);
                }
                k -= 2;
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
        super.dropActionChanged(evt);
        if (this.m_eventListenerList != null) {
            Object[] dropTargetListeners = this.m_eventListenerList.getListenerList();
            int k = dropTargetListeners.length - 2;
            while (k >= 0) {
                if (dropTargetListeners[k] == DropTargetListener.class) {
                    ((DropTargetListener)dropTargetListeners[k + 1]).dropActionChanged(evt);
                }
                k -= 2;
            }
        }
    }

    private static class P_DefaultDropHandler
    implements DropTargetListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean m_canImport;

        private P_DefaultDropHandler() {
        }

        private boolean actionSupported(int a) {
            int mask = a & 0x40000003;
            return mask != 0;
        }

        @Override
        public void dragEnter(DropTargetDragEvent evt) {
            DataFlavor[] currentFlavors = evt.getCurrentDataFlavors();
            JComponent jcomponent = (JComponent)evt.getDropTargetContext().getComponent();
            TransferHandler transferHandler = jcomponent.getTransferHandler();
            this.m_canImport = transferHandler != null && transferHandler.canImport(jcomponent, currentFlavors);
            int eventDropAction = evt.getDropAction();
            if (this.m_canImport && this.actionSupported(eventDropAction)) {
                evt.acceptDrag(eventDropAction);
            } else {
                evt.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent evt) {
            int eventDropAction = evt.getDropAction();
            if (this.m_canImport && this.actionSupported(eventDropAction)) {
                evt.acceptDrag(eventDropAction);
            } else {
                evt.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent evt) {
        }

        @Override
        public void drop(DropTargetDropEvent evt) {
            block5: {
                int eventDropAction = evt.getDropAction();
                JComponent jcomp = (JComponent)evt.getDropTargetContext().getComponent();
                TransferHandler transferHandler = jcomp.getTransferHandler();
                if (this.m_canImport && transferHandler != null && this.actionSupported(eventDropAction)) {
                    evt.acceptDrop(1);
                    try {
                        Transferable t = evt.getTransferable();
                        if (transferHandler instanceof TransferHandlerEx) {
                            evt.dropComplete(((TransferHandlerEx)transferHandler).importDataEx(jcomp, t, evt.getLocation()));
                            break block5;
                        }
                        evt.dropComplete(transferHandler.importData(jcomp, t));
                    }
                    catch (RuntimeException runtimeException) {
                        evt.dropComplete(false);
                    }
                } else {
                    evt.rejectDrop();
                }
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent evt) {
            int eventDropAction = evt.getDropAction();
            if (this.m_canImport && this.actionSupported(eventDropAction)) {
                evt.acceptDrag(eventDropAction);
            } else {
                evt.rejectDrag();
            }
        }
    }
}

