/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JButtonEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JScrollPaneEx;
import org.eclipse.scout.rt.ui.swing.ext.JTreeEx;
import org.eclipse.scout.rt.ui.swing.window.SwingWindowManager;

public class ComponentSpyAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static JDialog currentDialog;

    @Override
    public void actionPerformed(ActionEvent e) {
        Object x;
        TreePath path;
        Component c;
        if (currentDialog != null) {
            currentDialog.dispose();
            currentDialog = null;
        }
        if ((c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
            return;
        }
        Object s = null;
        if (c instanceof JTree && (path = ((JTree)c).getSelectionPath()) != null && (x = path.getLastPathComponent()) instanceof ITreeNode) {
            s = x;
        }
        if (s == null) {
            Component tmp = c;
            while (tmp != null) {
                if (tmp instanceof JComponent && (s = SwingScoutComposite.getScoutModelOnWidget((JComponent)tmp)) != null) break;
                tmp = tmp.getParent();
            }
        }
        this.showDetails(c, s);
    }

    protected void showDetails(Component c, Object s) {
        TreeNode root = this.createTree(c, s);
        final JTreeEx tree = new JTreeEx();
        tree.setModel(new DefaultTreeModel(root));
        ((JComponent)((Object)tree.getCellRenderer())).setBorder(new LineBorder(Color.lightGray));
        tree.setRowHeight(-1);
        this.visit(root, new ITreeVisitor(){

            @Override
            public void visit(TreeNode node) {
                tree.expandPath(new TreePath(((DefaultTreeModel)tree.getModel()).getPathToRoot(node)));
            }
        });
        final JDialog dlg = new JDialog(SwingWindowManager.getInstance().getActiveWindow());
        dlg.getRootPane().setName("Synth.Dialog");
        dlg.setTitle("Component Spy - Swing / Scout");
        dlg.setDefaultCloseOperation(2);
        dlg.setModal(false);
        dlg.getContentPane().add("Center", new JScrollPaneEx(tree));
        JPanelEx buttonPanel = new JPanelEx(new FlowLayoutEx(4));
        buttonPanel.add(new JButtonEx(new AbstractAction("Close"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                dlg.dispose();
            }
        }));
        dlg.getContentPane().add("South", buttonPanel);
        dlg.getContentPane().setPreferredSize(new Dimension(800, 600));
        dlg.pack();
        dlg.setVisible(true);
        currentDialog = dlg;
    }

    protected TreeNode createTree(Component c, Object s) {
        TextNode root = new TextNode("Root");
        TextNode scoutGroupNode = new TextNode("Scout Model Hierarchy");
        root.addChild(scoutGroupNode);
        scoutGroupNode.setParent(root);
        TextNode swingGroupNode = new TextNode("Swing Widget Hierarchy");
        root.addChild(swingGroupNode);
        swingGroupNode.setParent(root);
        ScoutNode currentScoutNode = null;
        while (s != null) {
            ScoutNode scoutNode;
            currentScoutNode = scoutNode = new ScoutNode(s, currentScoutNode);
            Object next = null;
            if (next == null && s instanceof IFormField) {
                next = ((IFormField)s).getParentField();
            }
            if (next == null && s instanceof IForm) {
                next = ((IForm)s).getOuterFormField();
            }
            if (next == null) {
                int nestedCount = s.getClass().getName().replaceAll("[^$]", "").trim().length();
                Field f = null;
                try {
                    f = s.getClass().getDeclaredField("this$" + (nestedCount - 1));
                    f.setAccessible(true);
                    next = f.get(s);
                }
                catch (Throwable throwable) {}
            }
            s = next;
        }
        if (currentScoutNode != null) {
            scoutGroupNode.addChild(currentScoutNode);
            currentScoutNode.setParent(scoutGroupNode);
        }
        SwingNode currentSwingNode = null;
        while (c != null && !(c instanceof RootPaneContainer)) {
            SwingNode swingNode;
            currentSwingNode = swingNode = new SwingNode(c, currentSwingNode);
            c = c.getParent();
        }
        if (currentSwingNode != null) {
            swingGroupNode.addChild(currentSwingNode);
            currentSwingNode.setParent(swingGroupNode);
        }
        return root;
    }

    protected void visit(TreeNode treeNode, ITreeVisitor v) {
        v.visit(treeNode);
        int n = treeNode.getChildCount();
        int i = 0;
        while (i < n) {
            this.visit(treeNode.getChildAt(i), v);
            ++i;
        }
    }

    public static void main(String[] args) {
        new ComponentSpyAction().actionPerformed(null);
    }

    static interface ITreeVisitor {
        public void visit(TreeNode var1);
    }

    static class ScoutNode
    implements TreeNode {
        private static final long serialVersionUID = 1L;
        private Object m_userObject;
        private boolean m_showContext;
        private ScoutNode m_markedChild;
        private TreeNode m_parent;
        private Vector<ScoutNode> m_children;

        public ScoutNode(Object data, ScoutNode markedChild) {
            this.m_userObject = data;
            this.m_markedChild = markedChild;
        }

        public Object getUserObject() {
            return this.m_userObject;
        }

        public Enumeration children() {
            this.checkChildren();
            return this.m_children.elements();
        }

        @Override
        public boolean getAllowsChildren() {
            this.checkChildren();
            return this.m_children.size() > 0;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            this.checkChildren();
            return this.m_children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            this.checkChildren();
            return this.m_children.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            this.checkChildren();
            return this.m_children.indexOf(node);
        }

        @Override
        public TreeNode getParent() {
            return this.m_parent;
        }

        public void setParent(TreeNode node) {
            this.m_parent = node;
        }

        @Override
        public boolean isLeaf() {
            this.checkChildren();
            return this.m_children.size() == 0;
        }

        private void checkChildren() {
            if (this.m_children == null) {
                this.loadChildren();
            }
        }

        public String toString() {
            return this.getHtml();
        }

        public String getHtml() {
            ICompositeField field;
            Object o = this.getUserObject();
            StringBuffer buf = new StringBuffer();
            buf.append("<html><head><style type=\"text/css\">td {border-width:1px; border-style:solid; border-color:gray;}</style></head><body>");
            boolean marked = this.getParent() instanceof ScoutNode && ((ScoutNode)this.getParent()).m_markedChild == this;
            buf.append("<table>");
            buf.append("<tr>");
            buf.append("<td>");
            String cname = o.getClass().getName();
            String prefix = cname.substring(0, cname.lastIndexOf(46) + 1);
            buf.append(prefix);
            buf.append("<b>");
            if (marked) {
                buf.append("<font color='blue'>");
            }
            buf.append(cname.substring(cname.lastIndexOf(46) + 1));
            if (marked) {
                buf.append("</font");
            }
            buf.append("</b>");
            Class<?> tmp = o.getClass();
            while (!tmp.getName().startsWith("org.eclipse.scout.")) {
                tmp = tmp.getSuperclass();
            }
            buf.append("<br>");
            buf.append("&nbsp;Type: " + tmp.getSimpleName());
            if (o instanceof ICompositeField) {
                field = (ICompositeField)o;
                buf.append("<br>");
                buf.append("&nbsp;GroupGrid: rowCount=" + field.getGridRowCount() + ", columnCount=" + field.getGridColumnCount());
            }
            if (o instanceof IFormField) {
                field = (IFormField)o;
                GridData gd = field.getGridData();
                buf.append("<br>");
                buf.append("&nbsp;GridData: x=" + gd.x + ", y=" + gd.y + ", w=" + gd.w + ", h=" + gd.h + ", weightX=" + gd.weightX + ", weightY=" + gd.weightY + ", useUiWidth=" + gd.useUiWidth + ", useUiHeight=" + gd.useUiHeight);
            }
            buf.append("</td>");
            buf.append("</tr>");
            buf.append("</table>");
            buf.append("</body></html>");
            return buf.toString();
        }

        private void loadChildren() {
            Vector<ScoutNode> newList = new Vector<ScoutNode>();
            Object o = this.getUserObject();
            IFormField[] childFields = null;
            if (o instanceof IForm) {
                childFields = new IFormField[]{((IForm)o).getRootGroupBox()};
            } else if (o instanceof ICompositeField) {
                childFields = ((ICompositeField)o).getFields();
            }
            if (childFields != null) {
                IFormField[] iFormFieldArray = childFields;
                int n = childFields.length;
                int n2 = 0;
                while (n2 < n) {
                    IFormField f = iFormFieldArray[n2];
                    ScoutNode newNode = null;
                    if (this.m_markedChild != null && this.m_markedChild.getUserObject() == f) {
                        newNode = this.m_markedChild;
                    } else if (this.m_showContext) {
                        newNode = new ScoutNode(f, null);
                    }
                    if (newNode != null) {
                        newList.add(newNode);
                        newNode.setParent(this);
                    }
                    ++n2;
                }
            }
            this.m_children = newList;
        }
    }

    static class SwingNode
    implements TreeNode {
        private static final long serialVersionUID = 1L;
        private Object m_userObject;
        private boolean m_showContext;
        private SwingNode m_markedChild;
        private TreeNode m_parent;
        private Vector<SwingNode> m_children;

        public SwingNode(Object data, SwingNode markedChild) {
            this.m_userObject = data;
            this.m_markedChild = markedChild;
        }

        public Object getUserObject() {
            return this.m_userObject;
        }

        public Enumeration children() {
            this.checkChildren();
            return this.m_children.elements();
        }

        @Override
        public boolean getAllowsChildren() {
            this.checkChildren();
            return this.m_children.size() > 0;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            this.checkChildren();
            return this.m_children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            this.checkChildren();
            return this.m_children.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            this.checkChildren();
            return this.m_children.indexOf(node);
        }

        @Override
        public TreeNode getParent() {
            return this.m_parent;
        }

        public void setParent(TreeNode node) {
            this.m_parent = node;
        }

        @Override
        public boolean isLeaf() {
            this.checkChildren();
            return this.m_children.size() == 0;
        }

        private void checkChildren() {
            if (this.m_children == null) {
                this.loadChildren();
            }
        }

        public String toString() {
            return this.getHtml();
        }

        public String getHtml() {
            LogicalGridData gd;
            Insets insets;
            Component c = (Component)this.getUserObject();
            StringBuffer buf = new StringBuffer();
            buf.append("<html><head><style type=\"text/css\">td {border-width:1px; border-style:solid; border-color:gray;}</style></head><body>");
            boolean marked = this.getParent() instanceof SwingNode && ((SwingNode)this.getParent()).m_markedChild == this;
            buf.append("<table>");
            buf.append("<tr>");
            buf.append("<td>");
            String cname = c.getClass().getName();
            String prefix = cname.substring(0, cname.lastIndexOf(46) + 1);
            buf.append(prefix);
            buf.append("<b>");
            if (marked) {
                buf.append("<font color='blue'>");
            }
            buf.append(cname.substring(cname.lastIndexOf(46) + 1));
            if (marked) {
                buf.append("</font");
            }
            buf.append("</b>");
            Class<?> tmp = c.getClass();
            while (!tmp.getName().startsWith("javax.swing.")) {
                tmp = tmp.getSuperclass();
            }
            buf.append("<br>");
            buf.append("&nbsp;Type: " + tmp.getSimpleName());
            Insets insets2 = insets = c instanceof JComponent ? ((JComponent)c).getInsets() : null;
            if (insets != null) {
                buf.append("<br>");
                buf.append("&nbsp;Insets: top=" + insets.top + ", left=" + insets.left + ", bottom=" + insets.bottom + ", right=" + insets.right);
            }
            Rectangle r = c.getBounds();
            buf.append("<br>");
            buf.append("&nbsp;Bounds: " + r.x + ", " + r.y + ", " + r.width + ", " + r.height);
            Dimension[] dims = new Dimension[]{c.getMinimumSize(), c.getPreferredSize(), c.getMaximumSize()};
            buf.append("<br>");
            buf.append("&nbsp;Sizes: (" + dims[0].width + ", " + dims[0].height + "), (" + dims[1].width + ", " + dims[1].height + "), (" + dims[2].width + ", " + dims[2].height + ")");
            LogicalGridData logicalGridData = gd = c instanceof JComponent ? (LogicalGridData)((JComponent)c).getClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME) : null;
            if (gd != null) {
                buf.append("<br>");
                buf.append("&nbsp;GridData: x=" + gd.gridx + ", y=" + gd.gridy + ", w=" + gd.gridw + ", h=" + gd.gridh + ", weightX=" + gd.weightx + ", weightY=" + gd.weighty + ", useUiWidth=" + gd.useUiWidth + ", useUiHeight=" + gd.useUiHeight);
            }
            if (c instanceof JComponent) {
                JComponent component = (JComponent)c;
                buf.append("<br>");
                buf.append("&nbsp;Colors: Foreground=");
                buf.append(this.colorToString(component.getForeground()));
                if (!component.isForegroundSet()) {
                    buf.append(" (from parent)");
                }
                buf.append(", Background=");
                buf.append(this.colorToString(component.getBackground()));
                if (!component.isBackgroundSet()) {
                    buf.append(" (from parent)");
                }
            }
            buf.append("</td>");
            buf.append("</tr>");
            buf.append("</table>");
            buf.append("</body></html>");
            return buf.toString();
        }

        private String colorToString(Color color) {
            if (color == null) {
                return "[null]";
            }
            return "[rgb=(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ") alpha=" + color.getAlpha() + " hex=" + Integer.toHexString(color.getRGB()) + "]";
        }

        private void loadChildren() {
            Vector<SwingNode> newList = new Vector<SwingNode>();
            Object o = this.getUserObject();
            Component[] childComps = null;
            if (o instanceof Container) {
                childComps = ((Container)o).getComponents();
            } else if (o instanceof RootPaneContainer) {
                childComps = new Component[]{((RootPaneContainer)o).getContentPane()};
            }
            if (childComps != null) {
                Component[] componentArray = childComps;
                int n = childComps.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    SwingNode newNode = null;
                    if (this.m_markedChild != null && this.m_markedChild.getUserObject() == c) {
                        newNode = this.m_markedChild;
                    } else if (this.m_showContext) {
                        newNode = new SwingNode(c, null);
                    }
                    if (newNode != null) {
                        newList.add(newNode);
                        newNode.setParent(this);
                    }
                    ++n2;
                }
            }
            this.m_children = newList;
        }
    }

    static class TextNode
    implements TreeNode {
        private static final long serialVersionUID = 1L;
        private Object m_userObject;
        private TreeNode m_parent;
        private Vector<TreeNode> m_children;

        public TextNode(Object data) {
            this.m_userObject = data;
            this.m_children = new Vector();
        }

        public Object getUserObject() {
            return this.m_userObject;
        }

        public void addChild(TreeNode node) {
            this.m_children.add(node);
        }

        public Enumeration children() {
            return this.m_children.elements();
        }

        @Override
        public boolean getAllowsChildren() {
            return this.m_children.size() > 0;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.m_children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.m_children.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.m_children.indexOf(node);
        }

        @Override
        public TreeNode getParent() {
            return this.m_parent;
        }

        public void setParent(TreeNode node) {
            this.m_parent = node;
        }

        @Override
        public boolean isLeaf() {
            return this.m_children.size() == 0;
        }

        public String toString() {
            return this.getUserObject().toString();
        }
    }
}

