/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.DropDownButtonLayout;

public class JDropDownButton
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final String UI_CLASS_ID = "DropDownButtonUI";
    private AbstractButton m_pushButton;
    private JButton m_menuButton;
    private Icon enabledDownArrow;
    private Icon disDownArrow;

    public JDropDownButton(AbstractButton mainButton) {
        this.setOpaque(false);
        this.m_pushButton = mainButton;
        this.m_pushButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JDropDownButton.this.getMenuButton().doClick();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JDropDownButton.this.getMenuButton().doClick();
                }
            }
        });
        this.add((Component)this.m_pushButton, "Center");
        this.enabledDownArrow = new SmallDownArrow(null, null);
        this.disDownArrow = new SmallDisabledDownArrow();
        this.m_menuButton = new JButton(this.enabledDownArrow);
        this.m_menuButton.setDisabledIcon(this.disDownArrow);
        this.m_menuButton.setFocusPainted(false);
        this.m_menuButton.setFocusable(false);
        this.add((Component)this.m_menuButton, "East");
        this.setLayout(new DropDownButtonLayout(this.m_pushButton, this.m_menuButton, 12));
        this.updateUI();
    }

    public AbstractButton getPushButton() {
        return this.m_pushButton;
    }

    public JButton getMenuButton() {
        return this.m_menuButton;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.m_pushButton.setEnabled(enable);
    }

    @Override
    public boolean isEnabled() {
        return this.m_pushButton.isEnabled();
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(UI_CLASS_ID) != null) {
            this.setUI(UIManager.getUI(this));
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return SwingUtility.getAdjustedToolTipLocation(e, this, this.getTopLevelAncestor());
    }

    private static class SmallDisabledDownArrow
    extends SmallDownArrow {
        public SmallDisabledDownArrow() {
            this.arrowColor = new Color(140, 140, 140);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            g.setColor(Color.white);
            g.drawLine(x + 3, y + 2, x + 4, y + 1);
            g.drawLine(x + 3, y + 3, x + 5, y + 1);
        }
    }

    private static class SmallDownArrow
    implements Icon {
        Color arrowColor = Color.black;

        private SmallDownArrow() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.arrowColor);
            g.drawLine(x, y, x + 4, y);
            g.drawLine(x + 1, y + 1, x + 3, y + 1);
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public int getIconHeight() {
            return 4;
        }

        /* synthetic */ SmallDownArrow(SmallDownArrow smallDownArrow, SmallDownArrow smallDownArrow2) {
            this();
        }
    }
}

