/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.IWaitSupport;
import org.eclipse.scout.rt.ui.swing.ext.JRootPaneEx;
import org.eclipse.scout.rt.ui.swing.ext.Windows7KeyHandler;

public class JFrameEx
extends JFrame
implements IWaitSupport {
    private static final long serialVersionUID = 1L;
    private boolean m_waitCursor;
    private boolean m_autoCorrectSize;
    private Windows7KeyHandler m_win7KeyHandler;
    private Rectangle m_nonMaximizedBounds;

    public JFrameEx() {
        this.setDefaultCloseOperation(2);
        this.enableEvents(1L);
        this.m_autoCorrectSize = true;
    }

    @Override
    protected void setRootPane(JRootPane root) {
        if (this.m_win7KeyHandler == null) {
            this.m_win7KeyHandler = new Windows7KeyHandler();
        }
        this.m_win7KeyHandler.uninstall();
        super.setRootPane(root);
        this.m_win7KeyHandler.install();
    }

    public boolean isAutoCorrectSize() {
        return this.m_autoCorrectSize;
    }

    public void setAutoCorrectSize(boolean b) {
        this.m_autoCorrectSize = b;
    }

    public Rectangle getNonMaximizedBounds() {
        return this.m_nonMaximizedBounds;
    }

    @Override
    public synchronized void setExtendedState(int state) {
        Rectangle r = this.getBounds();
        if ((state & 6) != 0) {
            this.m_nonMaximizedBounds = r;
        }
        Rectangle screen = SwingUtility.getFullScreenBoundsFor(r, false);
        screen.x = Integer.MAX_VALUE;
        screen.y = Integer.MAX_VALUE;
        this.setMaximizedBounds(screen);
        int oldState = this.getExtendedState();
        super.setExtendedState(state);
        if ((state & 6) != 0) {
            Rectangle fullscreen = SwingUtility.getFullScreenBoundsFor(this.getBounds(), true);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (ge.getScreenDevices().length >= 2 && fullscreen.x != 0 && this.getBounds() != null && (this.getBounds().width != screen.width || this.getBounds().height != screen.height)) {
                Rectangle screen0 = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
                screen.width = screen0.width;
                screen.height = screen0.height;
                this.setMaximizedBounds(screen);
                super.setExtendedState(oldState);
                super.setExtendedState(state);
            }
        }
        int newState = this.getExtendedState();
        this.firePropertyChange("state", oldState, newState);
    }

    @Override
    public void toFront() {
        this.setState(1);
        this.setState(0);
        super.toFront();
    }

    @Override
    public boolean isWaitCursor() {
        return this.m_waitCursor;
    }

    @Override
    public void setWaitCursor(boolean b) {
        if (b != this.m_waitCursor) {
            this.m_waitCursor = b;
            Container comp = this.getContentPane();
            if (this.m_waitCursor) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                comp.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
                comp.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    protected JRootPane createRootPane() {
        return new JRootPaneEx(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void reflow() {
                if (JFrameEx.this.m_autoCorrectSize) {
                    JFrameEx.this.pack();
                }
            }
        };
    }
}

