/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Font;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class JLabelEx
extends JLabel {
    private static final long serialVersionUID = 1L;
    private boolean m_bold = false;
    private String m_tooltipTextCached;

    public JLabelEx() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JLabelEx.this.setAppropriateTooltipTextEx();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                JLabelEx.this.setAppropriateTooltipTextEx();
            }
        });
    }

    @Override
    public void setText(String text) {
        if (SwingUtility.isMultilineLabelText(text)) {
            text = SwingUtility.createHtmlLabelText(text, false);
        }
        super.setText(text);
        this.setAppropriateTooltipTextEx();
    }

    public boolean isBold() {
        return this.m_bold;
    }

    public void setBold(boolean b) {
        if (b != this.m_bold) {
            this.m_bold = b;
            Font f = this.getFont();
            if (f != null && f.getStyle() == 1 != b) {
                f = new Font(f.getName(), b ? 1 : 0, f.getSize());
            }
            this.setFont(f);
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.m_tooltipTextCached = text = SwingUtility.createHtmlLabelText(text, true);
        super.setToolTipText(text);
    }

    private void setAppropriateTooltipTextEx() {
        int prefWidth = this.getPreferredSize().width;
        if (this.getWidth() < prefWidth) {
            super.setToolTipText(this.getText());
        } else {
            super.setToolTipText(this.m_tooltipTextCached);
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return SwingUtility.getAdjustedToolTipLocation(e, this, this.getTopLevelAncestor());
    }
}

