/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import org.eclipse.scout.rt.ui.swing.SingleLayout;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.ext.JButtonEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;

public class JSection
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color TEXT_COLOR = new Color(3238597);
    private static final Color ROLLOVER_COLOR = new Color(8366576);
    private static final Color BORDER_COLOR = new Color(11717622);
    private static final Color BACKGROUND_COLOR = new Color(15068668);
    private JButtonEx m_button;
    private JPanelEx m_body;
    private boolean m_expandable = true;
    private boolean m_expanded = true;

    public JSection(Component comp) {
        this.setOpaque(false);
        this.m_button = new JButtonEx(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(new GradientPaint(0.0f, 2.0f, BACKGROUND_COLOR, 0.0f, 20.0f, new Color(0xFFFFFF & BACKGROUND_COLOR.getRGB(), true), false));
                g2d.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                super.paintComponent(g);
            }
        };
        this.m_button.setOpaque(false);
        this.m_button.setFocusable(false);
        this.m_button.setBorder(new ButtonBorder());
        this.m_button.setContentAreaFilled(false);
        this.m_button.setHorizontalAlignment(10);
        this.m_button.setFocusPainted(false);
        this.m_button.setRolloverEnabled(true);
        this.m_button.setIcon(new ExpandedIcon(TEXT_COLOR));
        this.m_button.setRolloverIcon(new ExpandedIcon(ROLLOVER_COLOR));
        this.m_button.setForeground(TEXT_COLOR);
        this.m_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JSection.this.m_button.setForeground(ROLLOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JSection.this.m_button.setForeground(TEXT_COLOR);
            }
        });
        this.m_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSection.this.setExpanded(!JSection.this.isExpanded());
            }
        });
        this.m_body = new JPanelEx(new SingleLayout());
        this.m_body.setOpaque(false);
        this.m_body.add(comp);
        this.setLayout(new Layout());
        this.add(this.m_button);
        this.add(this.m_body);
    }

    public JComponent getContentPane() {
        return this.m_body;
    }

    public String getText() {
        return this.m_button.getText();
    }

    public void setText(String s) {
        this.m_button.setText(s);
    }

    public boolean isExpandable() {
        return this.m_expandable;
    }

    public void setExpandable(boolean expandable) {
        if (this.m_expandable != expandable) {
            this.m_expandable = expandable;
            this.m_button.setIcon(this.m_expandable ? new ExpandedIcon(TEXT_COLOR) : null);
            this.m_button.setRolloverIcon(this.m_expandable ? new ExpandedIcon(ROLLOVER_COLOR) : null);
            this.firePropertyChange("expandable", !this.m_expandable, this.m_expandable);
        }
    }

    public boolean isExpanded() {
        return this.m_expanded;
    }

    public void setExpanded(boolean expanded) {
        if (expanded != this.m_expanded) {
            this.m_expanded = expanded;
            this.m_body.setVisible(this.m_expanded);
            this.firePropertyChange("expanded", !this.m_expanded, this.m_expanded);
        }
    }

    private class ButtonBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 1L;

        private ButtonBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 3;
            insets.left = 3;
            insets.bottom = 0;
            insets.right = 3;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(x, y);
            g2d.setClip(new Rectangle(0, 0, width, height));
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, BORDER_COLOR, 0.0f, 20.0f, new Color(0xFFFFFF & BORDER_COLOR.getRGB(), true), false));
            g2d.drawRoundRect(0, 0, width - 1, height + 10, 8, 8);
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(-1, true), 0.0f, 20.0f, new Color(0xFFFFFF, true), false));
            g2d.drawRoundRect(1, 1, width - 3, height + 10, 8, 8);
            g2d.translate(-x, -y);
        }
    }

    private class ExpandedIcon
    implements Icon {
        private static final long serialVersionUID = 1L;
        private Color m_color;

        public ExpandedIcon(Color col) {
            this.m_color = col;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.m_color);
            if (JSection.this.isExpanded()) {
                int dx = 4;
                int dy = 6;
                int w = 8;
                int i = 0;
                while (i < 4) {
                    g.drawLine(x + dx, y + dy, x + dx + w - 1, y + dy);
                    ++dx;
                    ++dy;
                    w -= 2;
                    ++i;
                }
            } else {
                int dx = 6;
                int dy = 4;
                int w = 8;
                int i = 0;
                while (i < 4) {
                    g.drawLine(x + dx, y + dy, x + dx, y + dy + w - 1);
                    ++dx;
                    ++dy;
                    w -= 2;
                    ++i;
                }
            }
        }
    }

    private class Layout
    extends AbstractLayoutManager2 {
        private Layout() {
        }

        @Override
        protected void validateLayout(Container parent) {
        }

        @Override
        protected Dimension getLayoutSize(Container parent, int sizeflag) {
            Dimension d = new Dimension();
            d.height = 24;
            d.width = ((JSection)JSection.this).m_button.getPreferredSize().width;
            Dimension tmp = SwingLayoutUtility.getValidatedSize(JSection.this.m_body, sizeflag);
            d.width = Math.max(d.width, tmp.width);
            if (JSection.this.isExpanded()) {
                d.height += tmp.height;
            }
            Insets insets = parent.getInsets();
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            return d;
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            JSection.this.m_button.setBounds(insets.left, insets.top, size.width - insets.left - insets.right, 20);
            if (JSection.this.isExpanded()) {
                JSection.this.m_body.setBounds(insets.left, insets.top + 24, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom - 24);
            }
        }
    }
}

