/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.ScoutFieldStatus;
import org.eclipse.scout.rt.shared.AbstractIcons;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;

public class JStatusLabelEx
extends JComponent {
    private static final long serialVersionUID = 1L;
    private IProcessingStatus m_status;
    private boolean m_mandatoryLabelVisible;
    private JPanelEx m_labelPanel;
    private JLabelEx m_label;
    private JLabelEx m_mandatoryLabel;
    private JPanelEx m_iconPanel;
    private JLabelEx m_statusLabel;
    private Icon m_mandatoryIconEnabled;
    private Icon m_mandatoryIconDisabled;

    public JStatusLabelEx() {
        this.setLayout(new BorderLayoutEx(0, 0));
        this.m_mandatoryIconEnabled = Activator.getIcon("mandatory");
        this.m_mandatoryIconDisabled = Activator.getIcon("mandatory_disabled");
        this.m_labelPanel = new JPanelEx();
        this.m_labelPanel.setLayout(new FlowLayoutEx(0, 4, 0, 0));
        this.add((Component)this.m_labelPanel, "Center");
        this.m_iconPanel = new JPanelEx();
        this.m_iconPanel.setLayout(new FlowLayoutEx(0, 4, 0, 0));
        this.add((Component)this.m_iconPanel, "East");
        this.m_label = new JLabelEx();
        if (this.m_label.getBorder() == null) {
            this.m_label.setBorder(new EmptyBorder(0, 0, 0, 3));
        }
        this.m_label.setHorizontalTextPosition(10);
        this.m_label.setHorizontalAlignment(4);
        this.m_label.setVerticalAlignment(0);
        this.m_label.setVisible(false);
        this.m_labelPanel.add(this.m_label);
        this.m_statusLabel = new JLabelEx();
        this.m_statusLabel.setName("Synth.StatusLabelIcon");
        this.m_statusLabel.setVisible(false);
        this.m_iconPanel.add(this.m_statusLabel);
        this.m_mandatoryLabel = new JLabelEx();
        this.m_mandatoryLabel.setIcon(this.m_mandatoryIconEnabled);
        this.m_mandatoryLabel.setName("Synth.StatusLabelIcon");
        this.m_mandatoryLabel.setVisible(false);
        this.m_mandatoryLabelVisible = false;
        this.m_iconPanel.add(this.m_mandatoryLabel);
    }

    public void setMandatory(boolean b) {
        this.m_label.setBold(b);
    }

    public void showMandatoryIcon(boolean b) {
        this.m_mandatoryLabelVisible = b;
        if (this.m_status != null) {
            return;
        }
        this.m_mandatoryLabel.setVisible(b);
    }

    @Override
    public void setName(String name) {
        this.m_label.setName(name);
    }

    public void setFixedSize(int w) {
        LogicalGridData data = (LogicalGridData)this.getClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME);
        if (data != null) {
            data.widthHint = w > 0 ? w : 0;
        }
    }

    public void setLayoutWidthHint(int w) {
        LogicalGridData data = (LogicalGridData)this.getClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME);
        if (data != null) {
            data.widthHint = w;
        }
    }

    public void setLayoutHorizontalAlignment(int alignment) {
        FlowLayoutEx layout = (FlowLayoutEx)this.m_labelPanel.getLayout();
        if (layout != null) {
            layout.setAlignment(alignment);
        }
    }

    public String getText() {
        return this.m_label.getText();
    }

    public void setText(String text) {
        this.m_label.setText(text);
        this.m_label.setVisible(StringUtility.hasText((String)text));
    }

    public void setStatus(IProcessingStatus status) {
        this.m_status = status;
        if (this.m_status == null) {
            this.m_statusLabel.setVisible(false);
            this.m_statusLabel.setIcon(null);
            this.m_statusLabel.setToolTipText(null);
            this.m_mandatoryLabel.setVisible(this.m_mandatoryLabelVisible);
        } else {
            String iconId;
            String string = iconId = this.m_status instanceof ScoutFieldStatus ? ((ScoutFieldStatus)this.m_status).getIconId() : null;
            if (iconId == null) {
                switch (this.m_status.getSeverity()) {
                    case 4: 
                    case 16: {
                        iconId = AbstractIcons.StatusError;
                        break;
                    }
                    case 2: {
                        iconId = AbstractIcons.StatusWarning;
                        break;
                    }
                    default: {
                        iconId = AbstractIcons.StatusInfo;
                    }
                }
            }
            this.m_statusLabel.setIcon(Activator.getIcon(iconId));
            StringBuffer buf = new StringBuffer();
            if (this.m_status.getTitle() != null) {
                buf.append(this.m_status.getTitle());
            }
            if (this.m_status.getMessage() != null) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(this.m_status.getMessage());
            }
            this.m_statusLabel.setToolTipText(buf.toString());
            this.m_statusLabel.setVisible(true);
            this.m_mandatoryLabel.setVisible(false);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_label.setEnabled(enabled);
        this.m_mandatoryLabel.setIcon(enabled ? this.m_mandatoryIconEnabled : this.m_mandatoryIconDisabled);
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return SwingUtility.getAdjustedToolTipLocation(e, this, this.getTopLevelAncestor());
    }
}

