/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.IDropDownButtonListener;
import org.eclipse.scout.rt.ui.swing.ext.JTextFieldEx;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.HandCursorAdapater;

public class JTextFieldWithTransparentIcon
extends JTextFieldEx {
    private static final long serialVersionUID = 1L;
    private boolean m_textOverlappingIcon = false;
    private boolean m_mouseOver = false;
    private IconGroup m_iconGroup;
    private Collection<IDropDownButtonListener> m_listeners = new ArrayList<IDropDownButtonListener>();

    public JTextFieldWithTransparentIcon() {
        this.installDocumentListener();
        this.installMouseClickListener();
        this.installMouseListener();
        this.installComponentListener();
        new HandCursorAdapater(this);
        this.putClientProperty("onBackgroundPainter", this.createTransparentIcon());
    }

    private void installComponentListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JTextFieldWithTransparentIcon.this.updateTextOverlappingIcon();
            }
        });
    }

    private void installMouseClickListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!JTextFieldWithTransparentIcon.this.isIconEnabled()) {
                    return;
                }
                for (IDropDownButtonListener l : JTextFieldWithTransparentIcon.this.m_listeners) {
                    l.iconClicked(e.getSource());
                }
            }
        });
    }

    private void installDocumentListener() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                JTextFieldWithTransparentIcon.this.updateTextOverlappingIcon();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                JTextFieldWithTransparentIcon.this.updateTextOverlappingIcon();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JTextFieldWithTransparentIcon.this.updateTextOverlappingIcon();
            }
        });
    }

    public void installMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.updateIcon(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.updateIcon(false);
            }

            void updateIcon(boolean mouseOver) {
                if (!JTextFieldWithTransparentIcon.this.isIconEnabled()) {
                    return;
                }
                boolean oldMouseOver = JTextFieldWithTransparentIcon.this.m_mouseOver;
                if (oldMouseOver != mouseOver) {
                    JTextFieldWithTransparentIcon.this.m_mouseOver = mouseOver;
                    JTextFieldWithTransparentIcon.this.repaint();
                }
            }
        });
    }

    private void updateTextOverlappingIcon() {
        boolean oldTextOverlappingIcon = this.m_textOverlappingIcon;
        if (!this.m_iconGroup.hasIcon(IconGroup.IconState.NORMAL)) {
            this.m_textOverlappingIcon = false;
        } else {
            int insetsLeft;
            int iconWidth;
            int fieldWidth;
            int textWidth = this.calcTextWidth();
            boolean bl = this.m_textOverlappingIcon = textWidth > (fieldWidth = this.getSize().width) - (iconWidth = this.m_iconGroup.getIcon(IconGroup.IconState.NORMAL).getIconWidth()) - (insetsLeft = this.getInsets().left) - this.getInsetsRight();
        }
        if (oldTextOverlappingIcon != this.m_textOverlappingIcon) {
            this.repaint();
        }
    }

    private int calcTextWidth() {
        String text = this.getText();
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        Rectangle2D bounds = fm.getStringBounds(text, this.getGraphics());
        return (int)bounds.getWidth();
    }

    private boolean isIconEnabled() {
        return this.isEnabled() && this.isEditable();
    }

    protected Icon getIconForCurrentState() {
        Icon icon = this.m_iconGroup.getIcon(IconGroup.IconState.NORMAL);
        if (!this.isIconEnabled() && this.m_iconGroup.hasIcon(IconGroup.IconState.DISABLED)) {
            icon = this.m_iconGroup.getIcon(IconGroup.IconState.DISABLED);
        } else if (this.m_mouseOver && this.m_iconGroup.hasIcon(IconGroup.IconState.ROLLOVER)) {
            icon = this.m_iconGroup.getIcon(IconGroup.IconState.ROLLOVER);
        } else if (this.isTextOverlappingIcon() && this.m_iconGroup.hasIcon(IconGroup.IconState.SELECTED)) {
            icon = this.m_iconGroup.getIcon(IconGroup.IconState.SELECTED);
        }
        return icon;
    }

    private boolean isTextOverlappingIcon() {
        return this.m_textOverlappingIcon;
    }

    public void setIconGroup(IconGroup iconGroup) {
        this.m_iconGroup = iconGroup;
        this.updateTextOverlappingIcon();
    }

    public void addDropDownButtonListener(IDropDownButtonListener l) {
        this.m_listeners.add(l);
    }

    public void removeDropDownButtonListener(IDropDownButtonListener l) {
        this.m_listeners.remove(l);
    }

    protected Icon createTransparentIcon() {
        return new Icon(){

            @Override
            public int getIconHeight() {
                return 0;
            }

            @Override
            public int getIconWidth() {
                return 0;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Icon icon = JTextFieldWithTransparentIcon.this.getIconForCurrentState();
                if (icon != null) {
                    x = JTextFieldWithTransparentIcon.this.getWidth() - icon.getIconWidth() - JTextFieldWithTransparentIcon.this.getInsetsRight();
                    y = (JTextFieldWithTransparentIcon.this.getHeight() - icon.getIconHeight()) / 2;
                    icon.paintIcon(c, g, x, y);
                }
            }
        };
    }

    protected int getInsetsRight() {
        return 3;
    }
}

