/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreePath;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.dnd.DefaultDropTarget;

public class JTreeEx
extends JTree {
    private static final long serialVersionUID = 1L;
    private Dimension m_preferredScrollableViewportSize;

    public JTreeEx() {
        SwingUtility.installDefaultFocusHandling(this);
        this.setFocusCycleRoot(false);
        this.setVerifyInputWhenFocusTarget(true);
        this.setModel(null);
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(true);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public Enumeration<TreePath> getExpandedDescendants(TreePath path) {
        return null;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        if (text == null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        if (this.getToolTipText(event) != null) {
            return new Point(event.getX() + 4, event.getY() + 16);
        }
        return null;
    }

    @Override
    public Color getBackground() {
        Color bg;
        if (!this.isEnabled() && (bg = UIManager.getColor("control")) != null) {
            return bg;
        }
        return super.getBackground();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.firePropertyChange("name", null, name);
    }

    @Override
    public void setTransferHandler(TransferHandler newHandler) {
        TransferHandler oldHandler = (TransferHandler)this.getClientProperty("TransferHandler");
        this.putClientProperty("TransferHandler", newHandler);
        DropTarget dropHandler = this.getDropTarget();
        if (dropHandler == null || dropHandler instanceof UIResource) {
            if (newHandler == null) {
                this.setDropTarget(null);
            } else if (!GraphicsEnvironment.isHeadless()) {
                this.setDropTarget(new DefaultDropTarget(this));
            }
        }
        this.firePropertyChange("transferHandler", oldHandler, newHandler);
    }

    public Dimension getPreferredContentSize(int maxRowCount) {
        Rectangle max = new Rectangle();
        int r = 0;
        int nr = this.getRowCount();
        while (r < nr && r < maxRowCount) {
            max = max.union(this.getRowBounds(r));
            ++r;
        }
        return new Dimension(max.x + max.width, max.y + max.height);
    }

    @Override
    public TransferHandler getTransferHandler() {
        return (TransferHandler)this.getClientProperty("TransferHandler");
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.m_preferredScrollableViewportSize != null) {
            return this.m_preferredScrollableViewportSize;
        }
        return super.getPreferredScrollableViewportSize();
    }

    public void setPreferredScrollableViewportSize(Dimension d) {
        this.m_preferredScrollableViewportSize = d;
    }

    @Override
    public void scrollPathToVisible(TreePath treePath) {
        if (treePath != null) {
            this.makeVisible(treePath);
            Rectangle pathBounds = this.getPathBounds(treePath);
            if (pathBounds != null) {
                pathBounds.width = Math.max(30, (int)(0.25 * (double)pathBounds.width));
                this.scrollRectToVisible(pathBounds);
                if (this.accessibleContext != null) {
                    ((JTree.AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                }
            }
        }
    }
}

