/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public final class LookAndFeelUtility {
    private LookAndFeelUtility() {
    }

    public static Color translucent(Color color, int ratio) {
        int alpha = (int)Math.round((double)ratio * 2.5);
        if (alpha < 0) {
            alpha = 0;
        } else if (alpha > 255) {
            alpha = 255;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static void drawFocus(Graphics g, int x, int y, int w, int h) {
        Graphics2D g2d = (Graphics2D)g;
        Stroke old = g2d.getStroke();
        g2d.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{1.0f, 2.0f}, 1.0f));
        g2d.drawLine(x, y, x + w - 1, y);
        g2d.drawLine(x, y + h, x + w - 1, y + h);
        g2d.drawLine(x, y, x, y + h - 1);
        g2d.drawLine(x + w, y, x + w, y + h - 1);
        g2d.setStroke(old);
    }
}

