/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.JTree;

public class MouseClickedBugFix {
    private Point m_pressedLocation;
    private boolean m_clickConsumed;

    public MouseClickedBugFix(MouseEvent e) {
        this.m_pressedLocation = e.getPoint();
    }

    public void mouseReleased(MouseListener listener, MouseEvent e) {
        Component c;
        Point p = e.getPoint();
        boolean generateClick = false;
        if (!(this.m_clickConsumed || this.m_pressedLocation.equals(p) || (c = e.getComponent()) != null && !c.getBounds().contains(p))) {
            if (c instanceof JTree || c instanceof JTable) {
                if (Math.max(Math.abs(this.m_pressedLocation.x - p.x), Math.abs(this.m_pressedLocation.y - p.y)) <= 8) {
                    generateClick = true;
                }
            } else {
                generateClick = true;
            }
        }
        if (generateClick) {
            listener.mouseClicked(e);
        }
    }

    public boolean mouseClicked() {
        if (this.m_clickConsumed) {
            return true;
        }
        this.m_clickConsumed = true;
        return false;
    }
}

