/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.activitymap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapColumnModel;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapModel;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.JActivityMap;

public class JActivityMapHeader
extends JComponent {
    private static final long serialVersionUID = 1L;
    private JActivityMap m_map;
    private HashMap<Rectangle, String> m_tooltipMapCache;

    protected JActivityMapHeader(JActivityMap map) {
        this.m_map = map;
        this.setBackground(Color.white);
        this.setToolTipText("...");
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        for (Map.Entry<Rectangle, String> entry : this.getTooltipMapCache().entrySet()) {
            if (!entry.getKey().contains(e.getPoint())) continue;
            return entry.getValue();
        }
        return null;
    }

    private int getHeightFromModel() {
        ActivityMapModel model = this.m_map.getModel();
        return model != null ? model.getHeaderHeight() : 24;
    }

    public Rectangle getMajorHeaderRect(Object majorColumn) {
        Rectangle r = this.m_map.getRect(this.m_map.getColumnModel().getMajorColumnRange(majorColumn));
        r.y = 0;
        r.height = this.getHeight() / 2;
        return r;
    }

    public Rectangle getMinorHeaderRect(Object minorColumn) {
        Rectangle r = this.m_map.getRect(this.m_map.getColumnModel().getMinorColumnRange(minorColumn));
        r.y = this.getHeightFromModel() / 2 + 1;
        r.height = this.getHeightFromModel() - r.y;
        return r;
    }

    private Map<Rectangle, String> getTooltipMapCache() {
        if (this.m_tooltipMapCache == null) {
            Object[] majorCols;
            this.m_tooltipMapCache = new HashMap();
            ActivityMapColumnModel columnModel = this.m_map.getColumnModel();
            Object[] objectArray = majorCols = columnModel.getMajorColumns();
            int n = majorCols.length;
            int n2 = 0;
            while (n2 < n) {
                Object majorCol = objectArray[n2];
                this.m_tooltipMapCache.put(this.getMajorHeaderRect(majorCol), columnModel.getMajorColumnTooltipText(majorCol));
                Object[] objectArray2 = columnModel.getMinorColumns(majorCol);
                int n3 = objectArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object minorCol = objectArray2[n4];
                    this.m_tooltipMapCache.put(this.getMinorHeaderRect(minorCol), columnModel.getMinorColumnTooltipText(minorCol));
                    ++n4;
                }
                ++n2;
            }
        }
        return this.m_tooltipMapCache;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.m_tooltipMapCache = null;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = new Dimension(super.getPreferredSize().width, this.getHeightFromModel());
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Object[] majorCols = this.m_map.getColumnModel().getMajorColumns();
        this.paintMajorHeader(g, majorCols);
        ArrayList<Object> minorColList = new ArrayList<Object>();
        Object[] objectArray = majorCols;
        int n = majorCols.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            minorColList.addAll(Arrays.asList(this.m_map.getColumnModel().getMinorColumns(o)));
            ++n2;
        }
        Object[] minorCols = minorColList.toArray();
        this.paintMinorHeader(g, minorCols);
    }

    private void paintMajorHeader(Graphics g, Object[] majorCols) {
        Object o;
        g.setColor(this.getForeground());
        Font f = this.getFont();
        HashMap attributes = new HashMap(f.getAttributes());
        attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        g.setFont(new Font(attributes));
        ArrayList<Rectangle> majorRects = new ArrayList<Rectangle>();
        ArrayList<Rectangle> textRects = new ArrayList<Rectangle>();
        Object[] objectArray = majorCols;
        int n = majorCols.length;
        int n2 = 0;
        while (n2 < n) {
            Object o2 = objectArray[n2];
            Rectangle r = this.getMajorHeaderRect(o2);
            majorRects.add(r);
            textRects.add(r);
            ++n2;
        }
        FontMetrics fm = g.getFontMetrics();
        ArrayList<String> texts = new ArrayList<String>();
        int size = 2;
        ArrayList<Rectangle> validatedRects = new ArrayList<Rectangle>();
        Object[] objectArray2 = majorCols;
        int n3 = majorCols.length;
        int n4 = 0;
        while (n4 < n3) {
            o = objectArray2[n4];
            texts.add(this.m_map.getColumnModel().getMajorColumnText(o, size));
            ++n4;
        }
        if (!this.validateTextSizes(fm, texts, textRects, validatedRects)) {
            size = 1;
            texts.clear();
            objectArray2 = majorCols;
            n3 = majorCols.length;
            n4 = 0;
            while (n4 < n3) {
                o = objectArray2[n4];
                texts.add(this.m_map.getColumnModel().getMajorColumnText(o, size));
                ++n4;
            }
            if (!this.validateTextSizes(fm, texts, textRects, validatedRects)) {
                size = 0;
                texts.clear();
                objectArray2 = majorCols;
                n3 = majorCols.length;
                n4 = 0;
                while (n4 < n3) {
                    o = objectArray2[n4];
                    texts.add(this.m_map.getColumnModel().getMajorColumnText(o, size));
                    ++n4;
                }
                this.validateTextSizes(fm, texts, textRects, validatedRects);
            }
        }
        int i = 0;
        while (i < textRects.size()) {
            String text = texts.get(i);
            if (text != null && text.length() > 0) {
                Rectangle r = validatedRects.get(i);
                this.paintText(g, r, text, false, true);
            }
            ++i;
        }
        g.setColor(Color.lightGray);
        int h = this.getHeight();
        for (Rectangle r : majorRects) {
            g.drawLine(r.x, h - 2, r.x, h - 1);
            g.drawLine(r.x + r.width - 1, h - 2, r.x + r.width - 1, h - 1);
        }
    }

    private void paintMinorHeader(Graphics g, Object[] minorCols) {
        Object o;
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>();
        Object[] objectArray = minorCols;
        int n = minorCols.length;
        int n2 = 0;
        while (n2 < n) {
            Object o2 = objectArray[n2];
            rects.add(this.getMinorHeaderRect(o2));
            ++n2;
        }
        FontMetrics fm = g.getFontMetrics();
        ArrayList<String> texts = new ArrayList<String>();
        int size = 2;
        ArrayList<Rectangle> validatedRects = new ArrayList<Rectangle>();
        Object[] objectArray2 = minorCols;
        int n3 = minorCols.length;
        int n4 = 0;
        while (n4 < n3) {
            o = objectArray2[n4];
            texts.add(this.m_map.getColumnModel().getMinorColumnText(o, size));
            ++n4;
        }
        if (!this.validateTextSizes(fm, texts, rects, validatedRects)) {
            size = 1;
            texts.clear();
            objectArray2 = minorCols;
            n3 = minorCols.length;
            n4 = 0;
            while (n4 < n3) {
                o = objectArray2[n4];
                texts.add(this.m_map.getColumnModel().getMinorColumnText(o, size));
                ++n4;
            }
            if (!this.validateTextSizes(fm, texts, rects, validatedRects)) {
                size = 0;
                texts.clear();
                objectArray2 = minorCols;
                n3 = minorCols.length;
                n4 = 0;
                while (n4 < n3) {
                    o = objectArray2[n4];
                    texts.add(this.m_map.getColumnModel().getMinorColumnText(o, size));
                    ++n4;
                }
                this.validateTextSizes(fm, texts, rects, validatedRects);
            }
        }
        int i = 0;
        while (i < rects.size()) {
            Rectangle r = rects.get(i);
            String text = texts.get(i);
            this.paintText(g, r, text, true, true);
            ++i;
        }
    }

    private void paintText(Graphics g, Rectangle r, String text, boolean hcentered, boolean vcentered) {
        Shape oldShape = g.getClip();
        if (text != null) {
            FontMetrics fm = g.getFontMetrics();
            int dx = 2;
            int dy = 2 + fm.getAscent();
            if (hcentered) {
                int width = fm.stringWidth(text);
                dx = 2 + Math.max(0, r.width - 4 - width) / 2;
            }
            if (vcentered) {
                int height = fm.getAscent();
                dy = 2 + fm.getAscent() + Math.max(0, r.height - 4 - height) / 2;
            }
            g.clipRect(r.x + dx, r.y + 2, r.width - 4, r.height - 4);
            g.drawString(text, r.x + dx, r.y + dy);
        }
        g.setClip(oldShape);
    }

    private boolean validateTextSizes(FontMetrics fm, List<String> texts, List<Rectangle> rects, List<Rectangle> validatedRects) {
        validatedRects.clear();
        validatedRects.addAll(rects);
        boolean fits = true;
        int i = 0;
        while (i < validatedRects.size()) {
            String text = texts.get(i);
            if (text != null && text.length() > 0) {
                int k = i + 1;
                while (k < validatedRects.size() && (texts.get(k) == null || texts.get(k).length() == 0)) {
                    validatedRects.get((int)i).width += validatedRects.get((int)k).width;
                    validatedRects.get((int)k).width = 0;
                    ++k;
                }
                if (fm.stringWidth(text) > validatedRects.get((int)i).width - 4) {
                    fits = false;
                }
            }
            ++i;
        }
        return fits;
    }
}

