/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.activitymap;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import javax.swing.JComponent;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.JActivityMap;

public class JSelector
extends JComponent {
    private static final long serialVersionUID = 1L;
    private JActivityMap m_map;
    private boolean m_mousePressed;

    public JSelector(JActivityMap map) {
        this.setOpaque(false);
        this.m_map = map;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JSelector.this.checkCursorInternal(e.getPoint());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JSelector.this.checkCursorInternal(new Point(-100, -100));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JSelector.this.m_mousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JSelector.this.m_mousePressed = false;
                JSelector.this.checkCursorInternal(e.getPoint());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JSelector.this.checkCursorInternal(e.getPoint());
            }
        });
    }

    private void checkCursorInternal(Point p) {
        if (!this.m_mousePressed) {
            Cursor c = null;
            if (Math.abs(p.x - 0) <= 4) {
                c = Cursor.getPredefinedCursor(10);
            } else if (Math.abs(p.x - this.getWidth()) <= 4) {
                c = Cursor.getPredefinedCursor(11);
            }
            this.setCursor(c);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int[] indexes = this.m_map.getSelectedRows();
        double[] range = this.m_map.getSelectedRange();
        if (indexes.length > 0 && range != null) {
            int modelRowCount = this.m_map.getModel().getRowCount();
            int i = 0;
            while (i < indexes.length) {
                if (indexes[i] >= modelRowCount) {
                    indexes[i] = -1;
                }
                ++i;
            }
            if (indexes.length > 0 && range[1] - range[0] > 0.0) {
                int[] sortedIndexesFrom = new int[indexes.length];
                int[] sortedIndexesTo = new int[indexes.length];
                System.arraycopy(indexes, 0, sortedIndexesFrom, 0, indexes.length);
                Arrays.sort(sortedIndexesFrom);
                System.arraycopy(sortedIndexesFrom, 0, sortedIndexesTo, 0, sortedIndexesFrom.length);
                int i2 = sortedIndexesFrom.length - 1;
                while (i2 > 0) {
                    if (sortedIndexesFrom[i2] == sortedIndexesTo[i2 - 1] + 1) {
                        sortedIndexesTo[i2 - 1] = sortedIndexesTo[i2];
                        sortedIndexesFrom[i2] = -1;
                        sortedIndexesTo[i2] = -1;
                    }
                    --i2;
                }
                i2 = 0;
                while (i2 < sortedIndexesFrom.length) {
                    if (sortedIndexesFrom[i2] >= 0) {
                        Rectangle r = this.m_map.getCellRect(sortedIndexesFrom[i2], sortedIndexesTo[i2], range);
                        g.setColor(new Color(0x55FF55));
                        g.fillRect(1, r.y, 3, r.height);
                        g.setColor(new Color(0xFF5555));
                        g.fillRect(w - 3 - 1, r.y, 3, r.height);
                        g.setColor(Color.black);
                        g.drawRect(0, r.y, w - 1, r.height);
                    }
                    ++i2;
                }
            }
        }
    }
}

