/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.UIManager;
import org.eclipse.scout.rt.ui.swing.ext.calendar.AbstractCalendarCell;
import org.eclipse.scout.rt.ui.swing.ext.calendar.DateChooser;

public class SmallCalendarCell
extends AbstractCalendarCell {
    private static final long serialVersionUID = 1L;
    private DateChooser m_dateChooser;
    private Date m_repDate;
    protected boolean m_isMajor;
    protected boolean m_selected;
    protected Color m_majorColorForWork;
    protected Color m_minorColorForWork;
    protected Color m_majorColorForWeekend;
    protected Color m_minorColorForWeekend;
    protected Color m_selectedForeground;
    protected Color m_selectedBackground;
    protected Font m_defaultFont;
    protected Font m_selectedFont;

    public SmallCalendarCell(DateChooser dateChooser) {
        this.m_dateChooser = dateChooser;
        this.setHorizontalAlignment(0);
        this.m_majorColorForWork = UIManager.getColor("Calendar.date.work");
        this.m_minorColorForWork = UIManager.getColor("Calendar.date.workMinor");
        this.m_majorColorForWeekend = UIManager.getColor("Calendar.date.weekend");
        this.m_minorColorForWeekend = UIManager.getColor("Calendar.date.weekendMinor");
        this.m_selectedForeground = UIManager.getColor("Calendar.date.selected.foreground");
        this.m_selectedBackground = UIManager.getColor("Calendar.date.selected.background");
        this.m_defaultFont = UIManager.getFont("Calendar.date.font");
        this.m_selectedFont = UIManager.getFont("Calendar.date.selected.font");
    }

    @Override
    protected void onSpacePressed() {
        this.m_dateChooser.setSelectedDate(this.getRepresentedDate());
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    @Override
    public boolean isSelected() {
        return this.m_selected;
    }

    @Override
    public void setSelected(boolean b) {
        this.m_selected = b;
        if (b) {
            this.setFont(this.m_selectedFont);
            this.setForeground(this.m_selectedForeground);
            this.setBackground(this.m_selectedBackground);
            this.setOpaque(true);
        } else {
            this.setFont(this.m_defaultFont);
            this.updateGui();
            this.setBackground(null);
            this.setOpaque(false);
        }
    }

    @Override
    public Date getRepresentedDate() {
        return this.m_repDate;
    }

    @Override
    public void setRepresentedState(Calendar c, boolean isMajor, boolean firstColumn, int displayType) {
        this.setRepDate(new Date(c.getTime().getTime()));
        this.m_isMajor = isMajor;
        this.updateGui();
    }

    protected void updateGui() {
        this.setText(new SimpleDateFormat("dd").format(this.m_repDate));
        Color c = this.m_dateChooser != null && !this.m_dateChooser.isWorkDay(this.getRepresentedDate()) ? (this.m_isMajor ? this.m_majorColorForWeekend : this.m_minorColorForWeekend) : (this.m_isMajor ? this.m_majorColorForWork : this.m_minorColorForWork);
        this.setForeground(c);
    }

    @Override
    public int getTimelessItemCount() {
        return 0;
    }

    @Override
    public int getTimedItemCount() {
        return 0;
    }

    @Override
    public Object getItemAt(Point p) {
        return null;
    }

    @Override
    public void resetItemCache() {
    }

    protected void setRepDate(Date repDate) {
        this.m_repDate = repDate;
    }
}

