/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.chartbox;

import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.WeakEventListener;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.chartbox.ChartBoxEvent;
import org.eclipse.scout.rt.client.ui.form.fields.chartbox.ChartBoxListener;
import org.eclipse.scout.rt.client.ui.form.fields.chartbox.IChartBox;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SingleLayout;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.chartbox.ISwingChartProvider;
import org.eclipse.scout.rt.ui.swing.form.fields.chartbox.ISwingScoutChartBox;

public class SwingScoutChartBox
extends SwingScoutFieldComposite<IChartBox>
implements ISwingScoutChartBox {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutChartBox.class);
    private P_ScoutChartBoxListener m_scoutChartBoxListener;
    private ISwingChartProvider m_chartProvider;
    private JComponent m_chartComponent;

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel();
        container.add(label);
        JPanelEx chartPanel = new JPanelEx(new SingleLayout());
        chartPanel.setOpaque(false);
        container.add(chartPanel);
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(chartPanel);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    @Override
    public JPanel getSwingChartPanel() {
        return (JPanel)this.getSwingField();
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_scoutChartBoxListener != null) {
            ((IChartBox)this.getScoutObject()).removeChartBoxListener((ChartBoxListener)this.m_scoutChartBoxListener);
            this.m_scoutChartBoxListener = null;
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.m_scoutChartBoxListener == null) {
            this.m_scoutChartBoxListener = new P_ScoutChartBoxListener();
            ((IChartBox)this.getScoutObject()).addChartBoxListener((ChartBoxListener)this.m_scoutChartBoxListener);
        }
        IChartBox f = (IChartBox)this.getScoutObject();
        this.setChartQNameFromScout(f.getChartQName());
    }

    protected void setChartQNameFromScout(String qname) {
        JPanel chartPanel = this.getSwingChartPanel();
        chartPanel.removeAll();
        this.m_chartProvider = null;
        this.m_chartComponent = null;
        if (qname != null) {
            try {
                String[] parts = qname.split("/");
                if (parts.length == 2) {
                    this.m_chartProvider = (ISwingChartProvider)Platform.getBundle((String)parts[0]).loadClass(parts[1]).newInstance();
                    this.m_chartComponent = this.m_chartProvider.createChart(this);
                    chartPanel.add(this.m_chartComponent);
                } else {
                    LOG.error("chart qname must be of form: bundle-symbolic-name/class-name");
                }
            }
            catch (Exception e) {
                LOG.error("chart-qname: " + qname, (Throwable)e);
            }
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("chartQName")) {
            this.setChartQNameFromScout((String)newValue);
        }
    }

    private void handleChartBoxChangedInSwing(ChartBoxEvent e) {
        try {
            switch (e.getType()) {
                case 100: {
                    JPanel chartPanel = this.getSwingChartPanel();
                    JComponent newComp = this.m_chartProvider.refreshChart(this.m_chartComponent);
                    if (newComp != null && newComp != this.m_chartComponent) {
                        this.m_chartComponent = newComp;
                        chartPanel.removeAll();
                        chartPanel.add(this.m_chartComponent);
                    }
                    chartPanel.repaint();
                }
            }
        }
        catch (Exception ex) {
            LOG.error("chartBoxEvent=" + e, (Throwable)ex);
        }
    }

    private class P_ScoutChartBoxListener
    implements ChartBoxListener,
    WeakEventListener {
        private P_ScoutChartBoxListener() {
        }

        public void chartBoxChanged(final ChartBoxEvent e) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    SwingScoutChartBox.this.handleChartBoxChangedInSwing(e);
                }
            };
            SwingScoutChartBox.this.getSwingEnvironment().invokeSwingLater(t);
        }
    }
}

