/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.imagebox;

import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.IImageField;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.ImageFieldEvent;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.ImageFieldListener;
import org.eclipse.scout.rt.shared.data.basic.AffineTransformSpec;
import org.eclipse.scout.rt.shared.data.basic.BoundsSpec;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.imagebox.ISwingScoutImageField;
import org.eclipse.scout.rt.ui.swing.form.fields.imagebox.imageviewer.ImageTransformEvent;
import org.eclipse.scout.rt.ui.swing.form.fields.imagebox.imageviewer.ImageTransformListener;
import org.eclipse.scout.rt.ui.swing.form.fields.imagebox.imageviewer.SwingImageViewer;

public class SwingScoutImageField
extends SwingScoutFieldComposite<IImageField>
implements ISwingScoutImageField {
    private P_ScoutImageFieldListener m_scoutImageFieldListener;
    private DragGestureRecognizer m_dragSource;
    private DropTarget m_dropTarget;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel();
        container.add(label);
        SwingImageViewer imageViewer = new SwingImageViewer();
        SwingUtility.installDefaultFocusHandling(imageViewer);
        imageViewer.addMouseListener(new P_SwingPopupListener());
        imageViewer.addImageTransformListener(new P_SwingTransformListener());
        container.add(imageViewer);
        this.setSwingLabel(label);
        this.setSwingField(imageViewer);
        this.setSwingContainer(container);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    @Override
    public IImageField getScoutImageField() {
        return (IImageField)this.getScoutObject();
    }

    @Override
    public SwingImageViewer getSwingImageViewer() {
        return (SwingImageViewer)this.getSwingField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.m_scoutImageFieldListener == null) {
            this.m_scoutImageFieldListener = new P_ScoutImageFieldListener();
            this.getScoutImageField().addImageFieldListener((ImageFieldListener)this.m_scoutImageFieldListener);
        }
        IImageField imageField = this.getScoutImageField();
        this.setImageFromScout(imageField.getImageId(), imageField.getImage());
        this.setAnalysisRectangleFromScout(imageField.getAnalysisRectangle());
        this.setImageTransformFromScout(imageField.getImageTransform());
        this.setFocusVisibleFromScout(imageField.isFocusVisible());
        this.setAutoFitFromScout(imageField.isAutoFit());
        this.updateDropTransferTypesFromScout();
        this.updateDragTransferTypesFromScout();
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_scoutImageFieldListener != null) {
            this.getScoutImageField().removeImageFieldListener((ImageFieldListener)this.m_scoutImageFieldListener);
            this.m_scoutImageFieldListener = null;
        }
    }

    protected void setImageFromScout(String imageId, Object image) {
        if (image == null && imageId != null) {
            image = this.getSwingEnvironment().getImage(imageId);
        }
        this.getSwingImageViewer().setImage(image);
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        float swingAlignX = SwingUtility.createAlignmentX(scoutAlign);
        this.getSwingImageViewer().setAlignmentX(swingAlignX);
    }

    @Override
    protected void setVerticalAlignmentFromScout(int scoutAlign) {
        float swingAlignY = SwingUtility.createAlignmentY(scoutAlign);
        this.getSwingImageViewer().setAlignmentY(swingAlignY);
    }

    protected void setAnalysisRectangleFromScout(BoundsSpec r) {
        Rectangle swingRect = SwingUtility.createRectangle(r);
        this.getSwingImageViewer().setAnalysisRect(swingRect);
    }

    protected void setAutoFitFromScout(boolean b) {
        this.getSwingImageViewer().setAutoFit(b);
    }

    protected void setFocusVisibleFromScout(boolean b) {
        this.getSwingImageViewer().setFocusVisible(b);
    }

    protected void setImageTransformFromScout(AffineTransformSpec at) {
        this.getSwingImageViewer().setImageTransform(at.dx, at.dy, at.sx, at.sy, at.angle);
    }

    protected void updateDragTransferTypesFromScout() {
        int scoutDragTransfer = this.getScoutImageField().getDragType();
        if (scoutDragTransfer != 0) {
            if (this.m_dragSource == null) {
                this.m_dragSource = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.getSwingImageViewer(), 1, new P_DragGestureListener());
            }
            this.m_dragSource.setComponent(this.getSwingImageViewer());
        } else if (this.m_dragSource != null) {
            this.m_dragSource.setComponent(null);
        }
    }

    protected void updateDropTransferTypesFromScout() {
        if (this.getScoutImageField().getDropType() != 0) {
            if (this.m_dropTarget == null) {
                this.m_dropTarget = new DropTarget(this.getSwingImageViewer(), new P_DropTargetListener());
            }
            this.m_dropTarget.setComponent(this.getSwingImageViewer());
        } else if (this.m_dropTarget != null) {
            this.m_dropTarget.setComponent(null);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("imageId") || name.equals("image")) {
            this.setImageFromScout(this.getScoutImageField().getImageId(), this.getScoutImageField().getImage());
        } else if (name.equals("analysisRectangle")) {
            this.setAnalysisRectangleFromScout((BoundsSpec)newValue);
        } else if (name.equals("imageTransform")) {
            this.setImageTransformFromScout((AffineTransformSpec)newValue);
        } else if (name.equals("autoFit")) {
            this.setAutoFitFromScout((Boolean)newValue);
        } else if (name.equals("focusVisible")) {
            this.setFocusVisibleFromScout((Boolean)newValue);
        } else if (name.equals("dragType")) {
            this.updateDragTransferTypesFromScout();
        } else if (name.equals("dropType")) {
            this.updateDropTransferTypesFromScout();
        }
    }

    protected boolean isHandleScoutImageFieldEvent(ImageFieldEvent e) {
        switch (e.getType()) {
            case 10: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    protected void handleScoutImageFieldEventInSwing(ImageFieldEvent e) {
        switch (e.getType()) {
            case 20: {
                this.getSwingImageViewer().doFitImage();
                break;
            }
            case 10: {
                this.getSwingImageViewer().doZoomRectangle(SwingUtility.createRectangle(e.getZoomRectangle()));
            }
        }
    }

    protected void handleSwingPopup(final MouseEvent e) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                IMenu[] a = SwingScoutImageField.this.getScoutImageField().getUIFacade().firePopupFromUI();
                new SwingPopupWorker(SwingScoutImageField.this.getSwingEnvironment(), e.getComponent(), e.getPoint(), a).enqueue();
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 5678L);
    }

    protected void handleSwingImageTransform(ImageTransformEvent e) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        final AffineTransformSpec at = new AffineTransformSpec(e.getDx(), e.getDy(), e.getSx(), e.getSy(), e.getAngle());
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    SwingScoutImageField.this.addIgnoredScoutEvent(PropertyChangeEvent.class, "imageTransform");
                    SwingScoutImageField.this.getScoutImageField().getUIFacade().setImageTransformFromUI(at);
                }
                finally {
                    SwingScoutImageField.this.removeIgnoredScoutEvent(PropertyChangeEvent.class, "imageTransform");
                }
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    protected Transferable handleSwingDragRequest() {
        final Holder result = new Holder(TransferObject.class, null);
        if (this.getScoutImageField() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = SwingScoutImageField.this.getScoutImageField().getUIFacade().fireDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            try {
                this.getSwingEnvironment().invokeScoutLater(t, 5678L).join(5678L);
            }
            catch (InterruptedException interruptedException) {}
        }
        TransferObject scoutTransferable = (TransferObject)result.getValue();
        Transferable swingTransferable = null;
        swingTransferable = SwingUtility.createSwingTransferable(scoutTransferable);
        return swingTransferable;
    }

    protected void handleSwingDropAction(Transferable swingTransferable) {
        TransferObject scoutTransferable;
        if (this.getScoutImageField() != null && swingTransferable != null && (scoutTransferable = SwingUtility.createScoutTransferable(swingTransferable)) != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    SwingScoutImageField.this.getScoutImageField().getUIFacade().fireDropActionFromUi(scoutTransferable);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private class P_DragGestureListener
    implements DragGestureListener {
        private P_DragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Transferable to = SwingScoutImageField.this.handleSwingDragRequest();
            if (to != null) {
                dge.startDrag(null, to);
            }
        }
    }

    private class P_DropTargetListener
    implements DropTargetListener {
        private P_DropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(1);
            SwingScoutImageField.this.handleSwingDropAction(dtde.getTransferable());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    private class P_ScoutImageFieldListener
    implements ImageFieldListener {
        private P_ScoutImageFieldListener() {
        }

        public void imageFieldChanged(final ImageFieldEvent e) {
            if (SwingScoutImageField.this.isIgnoredScoutEvent(ImageFieldEvent.class, "" + e.getType())) {
                return;
            }
            if (SwingScoutImageField.this.isHandleScoutImageFieldEvent(e)) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        SwingScoutImageField.this.handleScoutImageFieldEventInSwing(e);
                    }
                };
                SwingScoutImageField.this.getSwingEnvironment().invokeSwingLater(t);
            }
        }
    }

    private class P_SwingPopupListener
    extends MouseAdapter {
        private P_SwingPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && e.getComponent().isEnabled()) {
                SwingScoutImageField.this.handleSwingPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && e.getComponent().isEnabled()) {
                SwingScoutImageField.this.handleSwingPopup(e);
            }
        }
    }

    private class P_SwingTransformListener
    implements ImageTransformListener {
        private P_SwingTransformListener() {
        }

        @Override
        public void transformChanged(ImageTransformEvent e) {
            SwingScoutImageField.this.handleSwingImageTransform(e);
        }
    }
}

