/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.mailfield;

import java.awt.Cursor;
import java.io.FileNotFoundException;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.ext.JLabelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.mailfield.SwingMailAttachment;
import sun.awt.shell.ShellFolder;

public class SwingMailAttachmentView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingMailAttachmentView.class);
    private SwingMailAttachment m_attachment;

    public SwingMailAttachmentView(SwingMailAttachment attachment) {
        this.m_attachment = attachment;
        this.createContent();
        this.setToolTipText(this.m_attachment.getFile().getName());
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    protected void createContent() {
        JLabelEx iconLabel = new JLabelEx();
        try {
            ShellFolder shellFolder = ShellFolder.getShellFolder(this.m_attachment.getFile());
            ImageIcon icon = new ImageIcon(shellFolder.getIcon(true));
            iconLabel.setIcon(icon);
        }
        catch (FileNotFoundException t) {
            LOG.warn(null, (Throwable)t);
        }
        iconLabel.setText(this.m_attachment.getFile().getName());
        iconLabel.setHorizontalTextPosition(0);
        iconLabel.setVerticalTextPosition(3);
        this.add("Center", iconLabel);
    }

    public SwingMailAttachment getAttachment() {
        return this.m_attachment;
    }
}

