/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.plannerfield.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.HashMap;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;
import org.eclipse.scout.rt.ui.swing.form.fields.plannerfield.layout.PlannerFieldLayoutConstraints;
import org.eclipse.scout.rt.ui.swing.form.fields.plannerfield.layout.SwingScoutGridData;

public class PlannerFieldLayout
extends AbstractLayoutManager2 {
    private HashMap<Component, PlannerFieldLayoutConstraints> m_constraints = new HashMap();
    private SwingScoutGridData m_sizes;

    public PlannerFieldLayout(ISwingEnvironment env, GridData gd) {
        this.m_sizes = new SwingScoutGridData(env, gd);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException("use add(Component comp, Object constraints)");
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof PlannerFieldLayoutConstraints)) {
            throw new IllegalArgumentException("constraints must be of type RangeLayoutConstraints");
        }
        this.m_constraints.put(comp, (PlannerFieldLayoutConstraints)constraints);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.m_constraints.remove(comp);
    }

    @Override
    protected void validateLayout(Container parent) {
    }

    @Override
    protected Dimension getLayoutSize(Container parent, int sizeflag) {
        return this.m_sizes.getLayoutSize(sizeflag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        this.verifyLayout(parent);
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component centerComponent = null;
            Component eastComponent = null;
            Component[] componentArray = parent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                c.setBounds(0, 0, 0, 0);
                PlannerFieldLayoutConstraints cons = this.m_constraints.get(c);
                if (cons != null) {
                    if (cons.fieldType == 1) {
                        centerComponent = c;
                    } else if (cons.fieldType == 2) {
                        eastComponent = c;
                    }
                }
                ++n2;
            }
            Dimension size = parent.getSize();
            int gap = 2;
            int wCenter = 0;
            int wEast = 0;
            if (centerComponent != null && eastComponent != null) {
                Dimension[] centerSizes = SwingLayoutUtility.getValidatedSizes(centerComponent);
                Dimension[] eastSizes = SwingLayoutUtility.getValidatedSizes(eastComponent);
                if (centerSizes[1].width + gap + eastSizes[1].width <= size.width) {
                    wEast = eastSizes[1].width;
                    wCenter = size.width - gap - wEast;
                } else if (centerSizes[1].width + gap + eastSizes[0].width <= size.width) {
                    wCenter = centerSizes[1].width;
                    wEast = size.width - gap - wCenter;
                } else if (centerSizes[0].width + gap + eastSizes[0].width <= size.width) {
                    wEast = eastSizes[0].width;
                    wCenter = size.width - gap - wEast;
                } else if (centerSizes[0].width + gap + eastSizes[0].width <= size.width) {
                    wCenter = centerSizes[0].width;
                    wEast = Math.max(0, size.width - gap - wCenter);
                }
            }
            if (centerComponent != null) {
                centerComponent.setBounds(0, 0, wCenter, size.height);
            }
            if (eastComponent != null) {
                eastComponent.setBounds(wCenter + gap, 0, wEast, size.height);
            }
        }
    }
}

