/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.rangebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.swing.form.fields.rangebox.ISwingScoutSequenceBox;

public class SwingScoutSequenceBox
extends SwingScoutFieldComposite<ISequenceBox>
implements ISwingScoutSequenceBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutSequenceBox.class);
    private PropertyChangeListener m_scoutMandatoryChangeListener;
    private PropertyChangeListener m_scoutErrorStatusChangeListener;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setName(String.valueOf(((ISequenceBox)this.getScoutObject()).getClass().getName()) + ".container");
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel();
        container.add(label);
        JPanelEx innerFieldsContainer = new JPanelEx();
        container.add(innerFieldsContainer);
        IFormField[] scoutFields = ((ISequenceBox)this.getScoutObject()).getFields();
        int visibleCount = 0;
        int i = 0;
        while (i < scoutFields.length) {
            ISwingScoutFormField swingScoutComposite = this.getSwingEnvironment().createFormField(innerFieldsContainer, scoutFields[i]);
            JStatusLabelEx childLabel = swingScoutComposite.getSwingLabel();
            if (childLabel != null) {
                childLabel.setFixedSize(0);
                if (swingScoutComposite.getScoutObject() instanceof IFormField) {
                    IFormField myScoutObject = (IFormField)swingScoutComposite.getScoutObject();
                    if (myScoutObject.isVisible()) {
                        ++visibleCount;
                    }
                    if (visibleCount > 1 && !childLabel.isVisible()) {
                        childLabel.setVisible(true);
                        childLabel.setText("");
                    }
                }
            }
            SwingScoutFormFieldGridData data = new SwingScoutFormFieldGridData(scoutFields[i]){

                @Override
                public void validate() {
                    super.validate();
                    this.useUiWidth = !((ISequenceBox)SwingScoutSequenceBox.this.getScoutObject()).isEqualColumnWidths();
                    this.useUiHeight = true;
                }
            };
            swingScoutComposite.getSwingContainer().putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, data);
            innerFieldsContainer.add(swingScoutComposite.getSwingContainer());
            ++i;
        }
        this.setSwingLabel(label);
        this.setSwingField(innerFieldsContainer);
        this.setSwingContainer(container);
        innerFieldsContainer.setLayout(new LogicalGridLayout(this.getSwingEnvironment(), this.getSwingEnvironment().getFormColumnGap(), 0));
        container.setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
        this.setChildMandatoryFromScout();
    }

    @Override
    public JPanel getSwingRangeBox() {
        return (JPanel)this.getSwingField();
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.getSwingRangeBox().setEnabled(b);
    }

    protected void setChildMandatoryFromScout() {
        boolean inheritedMandatory = false;
        IFormField[] iFormFieldArray = ((ISequenceBox)this.getScoutObject()).getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isVisible() && f instanceof IValueField) {
                inheritedMandatory = ((IValueField)f).isMandatory();
                break;
            }
            ++n2;
        }
        this.setMandatoryFromScout(inheritedMandatory);
    }

    protected void setChildErrorStatusFromScout() {
        IProcessingStatus inheritedErrorStatus = null;
        IFormField[] iFormFieldArray = ((ISequenceBox)this.getScoutObject()).getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isVisible() && f instanceof IValueField) {
                inheritedErrorStatus = ((IValueField)f).getErrorStatus();
                break;
            }
            ++n2;
        }
        this.setErrorStatusFromScout(inheritedErrorStatus);
    }

    @Override
    protected void attachScout() {
        IFormField f;
        super.attachScout();
        this.m_scoutMandatoryChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        SwingScoutSequenceBox.this.setChildMandatoryFromScout();
                    }
                };
                SwingScoutSequenceBox.this.getSwingEnvironment().invokeSwingLater(j);
            }
        };
        IFormField[] iFormFieldArray = ((ISequenceBox)this.getScoutObject()).getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = iFormFieldArray[n2];
            f.addPropertyChangeListener("mandatory", this.m_scoutMandatoryChangeListener);
            f.addPropertyChangeListener("visible", this.m_scoutMandatoryChangeListener);
            ++n2;
        }
        this.m_scoutErrorStatusChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        SwingScoutSequenceBox.this.setChildErrorStatusFromScout();
                    }
                };
                SwingScoutSequenceBox.this.getSwingEnvironment().invokeSwingLater(j);
            }
        };
        iFormFieldArray = ((ISequenceBox)this.getScoutObject()).getFields();
        n = iFormFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            f = iFormFieldArray[n2];
            f.addPropertyChangeListener("errorStatus", this.m_scoutErrorStatusChangeListener);
            ++n2;
        }
    }

    @Override
    protected void detachScout() {
        IFormField f;
        int n;
        int n2;
        IFormField[] iFormFieldArray;
        if (this.m_scoutMandatoryChangeListener != null) {
            iFormFieldArray = ((ISequenceBox)this.getScoutObject()).getFields();
            n2 = iFormFieldArray.length;
            n = 0;
            while (n < n2) {
                f = iFormFieldArray[n];
                f.removePropertyChangeListener("mandatory", this.m_scoutMandatoryChangeListener);
                f.removePropertyChangeListener("visible", this.m_scoutMandatoryChangeListener);
                ++n;
            }
            this.m_scoutMandatoryChangeListener = null;
        }
        if (this.m_scoutErrorStatusChangeListener != null) {
            iFormFieldArray = ((ISequenceBox)this.getScoutObject()).getFields();
            n2 = iFormFieldArray.length;
            n = 0;
            while (n < n2) {
                f = iFormFieldArray[n];
                f.removePropertyChangeListener("errorStatus", this.m_scoutErrorStatusChangeListener);
                ++n;
            }
            this.m_scoutErrorStatusChangeListener = null;
        }
        super.detachScout();
    }
}

