/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.splitbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSplitPane;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.splitbox.ISwingScoutSplitBox;

public class SwingScoutSplitBox
extends SwingScoutFieldComposite<ISplitBox>
implements ISwingScoutSplitBox {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutSplitBox.class);
    private OptimisticLock lockSplitter = new OptimisticLock();

    @Override
    protected void initializeSwing() {
        JSplitPane container = new JSplitPane(((ISplitBox)this.getScoutObject()).isSplitHorizontal() ? 1 : 0, true);
        container.setName(String.valueOf(((ISplitBox)this.getScoutObject()).getClass().getSimpleName()) + ".container");
        container.setBorder(null);
        IFormField[] scoutFields = ((ISplitBox)this.getScoutObject()).getFields();
        if (scoutFields.length == 2) {
            ISwingScoutFormField swingScoutComposite = this.getSwingEnvironment().createFormField(container, scoutFields[0]);
            container.add(swingScoutComposite.getSwingContainer());
            ISwingScoutFormField swingScoutComposite1 = this.getSwingEnvironment().createFormField(container, scoutFields[1]);
            container.add(swingScoutComposite1.getSwingContainer());
            container.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SwingScoutSplitBox.this.setSplitterPositionFromSwing();
                }
            });
        } else {
            LOG.error("SplitBox allows exact 2 inner fields.");
        }
        this.setSwingContainer(container);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        int[] a = null;
        String propName = ((ISplitBox)this.getScoutObject()).getCacheSplitterPositionPropertyName();
        if (!StringUtility.isNullOrEmpty((String)propName) && ((ISplitBox)this.getScoutObject()).isCacheSplitterPosition()) {
            try {
                a = ClientUIPreferences.getInstance().getPropertyIntArray(propName);
            }
            catch (Throwable throwable) {}
        }
        if (a != null && a.length == 2) {
            this.setSplitterPosition(a[0], a[1]);
        } else {
            this.setSplitterPositionFromScout();
        }
    }

    protected void setSplitterPositionFromScout() {
        try {
            double p;
            if (this.lockSplitter.acquire() && (p = ((ISplitBox)this.getScoutObject()).getSplitterPosition()) > 0.0 && p < 1.0) {
                this.getSwingContainer().setDividerLocation(p);
                this.getSwingContainer().setResizeWeight(p);
            }
        }
        finally {
            this.lockSplitter.release();
        }
    }

    protected void setSplitterPosition(int leftWidth, int rightWidth) {
        try {
            double total;
            if (this.lockSplitter.acquire() && (total = (double)(leftWidth + rightWidth)) > 0.0 && leftWidth > 0) {
                double d = (double)leftWidth / total;
                this.getSwingContainer().setDividerLocation(leftWidth);
                this.getSwingContainer().setResizeWeight(d);
            }
        }
        finally {
            this.lockSplitter.release();
        }
    }

    protected void setSplitterPositionFromSwing() {
        String propName = ((ISplitBox)this.getScoutObject()).getCacheSplitterPositionPropertyName();
        if (!StringUtility.isNullOrEmpty((String)propName)) {
            if (((ISplitBox)this.getScoutObject()).isCacheSplitterPosition()) {
                int total = (this.getSwingContainer().getOrientation() == 1 ? this.getSwingContainer().getWidth() : this.getSwingContainer().getHeight()) - this.getSwingContainer().getDividerSize();
                if (total > 32) {
                    int left = this.getSwingContainer().getDividerLocation();
                    int right = total - left;
                    ClientUIPreferences.getInstance().setPropertyIntArray(propName, new int[]{left, right});
                }
            } else {
                ClientUIPreferences.getInstance().setPropertyIntArray(propName, null);
            }
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (!"splitterEnabled".equals(name) && "splitterPosition".equals(name)) {
            this.setSplitterPositionFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    @Override
    public JSplitPane getSwingContainer() {
        return (JSplitPane)super.getSwingContainer();
    }
}

