/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.tabbox;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.ui.swing.ext.JTabbedPaneEx;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.tabbox.ISwingScoutTabBox;
import org.eclipse.scout.rt.ui.swing.form.fields.tabbox.ISwingScoutTabItem;
import org.eclipse.scout.rt.ui.swing.form.fields.tabbox.SwingScoutTabItem;

public class SwingScoutTabBox
extends SwingScoutFieldComposite<ITabBox>
implements ISwingScoutTabBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutTabBox.class);
    private HashMap<IGroupBox, Integer> m_scoutGroupToIndex;
    private HashMap<Component, IGroupBox> m_swingGroupToScoutGroup;
    private PropertyChangeListener m_scoutVisiblePropertyListener;
    private int m_oldSelectedIndex = 0;

    @Override
    protected void initializeSwing() {
        this.m_scoutGroupToIndex = new HashMap();
        this.m_swingGroupToScoutGroup = new HashMap();
        JTabbedPaneEx swingPane = new JTabbedPaneEx();
        swingPane.setOpaque(false);
        swingPane.setFocusable(true);
        IGroupBox[] scoutGroupBoxes = ((ITabBox)this.getScoutObject()).getGroupBoxes();
        int i = 0;
        while (i < scoutGroupBoxes.length) {
            this.m_scoutGroupToIndex.put(scoutGroupBoxes[i], i);
            ++i;
        }
        this.setSwingField(swingPane);
        this.setSwingLabel(null);
        this.setSwingContainer(swingPane);
        i = 0;
        while (i < scoutGroupBoxes.length) {
            this.checkTabItemFor(scoutGroupBoxes[i]);
            ++i;
        }
        this.setTabItemSelected(0, true);
        swingPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingScoutTabBox.this.setSelectedTabFromSwing();
            }
        });
    }

    private void checkTabItemFor(IGroupBox g) {
        JTabbedPane pane = this.getSwingTabbedPane();
        if (g.isVisible()) {
            int modelIndex = this.m_scoutGroupToIndex.get(g);
            int viewIndex = 0;
            int i = 0;
            int n = pane.getTabCount();
            while (i < n) {
                Component comp = pane.getComponentAt(i);
                IGroupBox test = this.m_swingGroupToScoutGroup.get(comp);
                if (test == g) {
                    return;
                }
                int x = this.m_scoutGroupToIndex.get(test);
                if (x < modelIndex) {
                    ++viewIndex;
                }
                ++i;
            }
            ISwingScoutTabItem tabComposite = this.getSwingEnvironment().createTabItem(pane, g);
            if (tabComposite != null) {
                JComponent comp = tabComposite.getSwingContainer();
                this.m_swingGroupToScoutGroup.put(comp, g);
                pane.insertTab("", tabComposite.getSwingTabIcon(), comp, null, viewIndex);
            }
        } else {
            int i = 0;
            int n = pane.getTabCount();
            while (i < n) {
                Component comp = pane.getComponentAt(i);
                IGroupBox test = this.m_swingGroupToScoutGroup.get(comp);
                if (test == g) {
                    this.m_swingGroupToScoutGroup.remove(comp);
                    pane.removeTabAt(i);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public JTabbedPane getSwingTabbedPane() {
        return (JTabbedPane)this.getSwingField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.applyTopMarginIfTabBoxIsNotOnTop();
        if (this.m_scoutVisiblePropertyListener == null) {
            this.m_scoutVisiblePropertyListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent e) {
                    SwingScoutTabBox.this.getSwingEnvironment().invokeSwingLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingScoutTabBox.this.checkTabItemFor((IGroupBox)e.getSource());
                        }
                    });
                }
            };
            for (IGroupBox g : this.m_scoutGroupToIndex.keySet()) {
                g.addPropertyChangeListener("visible", this.m_scoutVisiblePropertyListener);
            }
        }
        this.setSelectedTabFromScout();
    }

    private void applyTopMarginIfTabBoxIsNotOnTop() {
        if (((ITabBox)this.getScoutObject()).getGridData().y != 0) {
            this.getSwingTabbedPane().setName("TabbedPane.topMargin");
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_scoutVisiblePropertyListener != null) {
            for (IGroupBox g : this.m_scoutGroupToIndex.keySet()) {
                g.removePropertyChangeListener("visible", this.m_scoutVisiblePropertyListener);
            }
            this.m_scoutVisiblePropertyListener = null;
        }
        super.detachScout();
    }

    protected void setSelectedTabFromSwing() {
        this.updateTabItemSelected();
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        Component comp = this.getSwingTabbedPane().getSelectedComponent();
        final IGroupBox box = this.m_swingGroupToScoutGroup.get(comp);
        if (box != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITabBox)SwingScoutTabBox.this.getScoutObject()).getUIFacade().setSelectedTabFromUI(box);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void setSelectedTabFromScout() {
        IGroupBox selectedTab = ((ITabBox)this.getScoutObject()).getSelectedTab();
        JTabbedPane pane = this.getSwingTabbedPane();
        int index = 0;
        while (index < pane.getTabCount()) {
            Component comp = pane.getComponentAt(index);
            IGroupBox test = this.m_swingGroupToScoutGroup.get(comp);
            if (test == selectedTab) break;
            ++index;
        }
        if (index >= pane.getTabCount()) {
            index = 0;
        }
        if (index != pane.getSelectedIndex() && index >= 0 && index < pane.getTabCount()) {
            this.getSwingTabbedPane().setSelectedIndex(index);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("selectedTab")) {
            this.setSelectedTabFromScout();
        }
    }

    private void updateTabItemSelected() {
        JTabbedPane pane = this.getSwingTabbedPane();
        int index = pane.getSelectedIndex();
        if (index != this.m_oldSelectedIndex) {
            this.setTabItemSelected(this.m_oldSelectedIndex, false);
            this.setTabItemSelected(index, true);
            this.m_oldSelectedIndex = index;
        }
    }

    private void setTabItemSelected(int index, boolean selected) {
        Icon icon;
        if (index >= 0 && index < this.getSwingTabbedPane().getTabCount() && (icon = this.getSwingTabbedPane().getIconAt(index)) instanceof SwingScoutTabItem.SwingTabIcon) {
            ((SwingScoutTabItem.SwingTabIcon)icon).setSelected(selected);
        }
    }
}

