/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.tablefield;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JLabelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swing.form.fields.tablefield.ISwingTableStatus;

public class SwingTableStatus
implements ISwingTableStatus {
    private final ISwingEnvironment m_env;
    private final JLabel m_populateLabel;
    private final JLabel m_selectionLabel;

    public SwingTableStatus(ISwingEnvironment env, JComponent container, ITableField<?> model) {
        this.m_env = env;
        this.m_populateLabel = new JLabelEx();
        if (!SwingUtility.isSynth()) {
            this.m_populateLabel.setBorder(new BorderUIResource(new EmptyBorder(0, 4, 0, 0)));
        }
        this.m_populateLabel.setName("Synth.TableStatus");
        LogicalGridData tableGridData = LogicalGridDataBuilder.createField(this.m_env, model.getGridData());
        LogicalGridData gd = new LogicalGridData();
        gd.gridx = tableGridData.gridx;
        gd.gridy = tableGridData.gridy + tableGridData.gridh;
        gd.gridw = tableGridData.gridw;
        gd.gridh = 1;
        gd.weightx = tableGridData.weightx;
        gd.weighty = 0.0;
        gd.fillHorizontal = true;
        this.m_populateLabel.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, gd);
        container.add(this.m_populateLabel);
        this.m_selectionLabel = new JLabelEx();
        if (!SwingUtility.isSynth()) {
            this.m_selectionLabel.setBorder(new BorderUIResource(new EmptyBorder(0, 4, 0, 0)));
        }
        this.m_selectionLabel.setName("Synth.TableStatus");
        tableGridData = LogicalGridDataBuilder.createField(this.m_env, model.getGridData());
        gd = new LogicalGridData();
        gd.gridx = tableGridData.gridx;
        gd.gridy = tableGridData.gridy + tableGridData.gridh + 1;
        gd.gridw = tableGridData.gridw;
        gd.gridh = 1;
        gd.weightx = tableGridData.weightx;
        gd.weighty = 0.0;
        gd.fillHorizontal = true;
        this.m_selectionLabel.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, gd);
        container.add(this.m_selectionLabel);
    }

    @Override
    public void setStatus(IProcessingStatus populateStatus, IProcessingStatus selectionStatus) {
        this.setStatusImpl(this.m_populateLabel, populateStatus, true);
        this.setStatusImpl(this.m_selectionLabel, selectionStatus, true);
    }

    private void setStatusImpl(JLabel field, IProcessingStatus status, boolean hideWhenNullStatus) {
        if (status == null) {
            field.setText(null);
            if (hideWhenNullStatus) {
                field.setVisible(false);
            }
            return;
        }
        field.setVisible(true);
        String text = status.getMessage();
        if (text != null) {
            text = text.replaceAll("[\\s]+", " ");
        }
        field.setText(text);
        switch (status.getSeverity()) {
            case 4: 
            case 16: {
                field.setForeground(new Color(0xCC0000));
                break;
            }
            case 2: {
                field.setForeground(new Color(16685603));
                break;
            }
            default: {
                field.setForeground(null);
            }
        }
    }
}

