/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.textfield;

import org.eclipse.scout.rt.client.services.common.spellchecker.ISpellingMonitor;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextFieldEx;
import org.eclipse.scout.rt.ui.swing.form.fields.textfield.ISwingScoutTextField;
import org.eclipse.scout.rt.ui.swing.form.fields.textfield.SwingScoutTextFieldComposite;
import org.eclipse.scout.rt.ui.swing.spellchecker.ISwingSpellCheckerService;
import org.eclipse.scout.rt.ui.swing.spellchecker.SwingFieldHolder;
import org.eclipse.scout.service.SERVICES;

public class SwingScoutTextField
extends SwingScoutTextFieldComposite<IStringField>
implements ISwingScoutTextField {
    private ISpellingMonitor m_spellingMonitor;

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel();
        container.add(label);
        JTextFieldEx textField = new JTextFieldEx();
        container.add(textField);
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(textField);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    @Override
    public JTextFieldEx getSwingTextField() {
        return (JTextFieldEx)this.getSwingTextComponent();
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        int swingAlign = SwingUtility.createHorizontalAlignment(scoutAlign);
        this.getSwingTextField().setHorizontalAlignment(swingAlign);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        ISwingSpellCheckerService spellCheckerService = (ISwingSpellCheckerService)SERVICES.getService(ISwingSpellCheckerService.class);
        if (spellCheckerService != null && spellCheckerService.isInstalled()) {
            this.m_spellingMonitor = spellCheckerService.createSpellingMonitor(new SwingFieldHolder(this, this.getSwingTextField()));
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_spellingMonitor != null) {
            this.m_spellingMonitor.dispose();
            this.m_spellingMonitor = null;
        }
        super.detachScout();
    }
}

