/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.treefield;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.ITreeField;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.basic.tree.ISwingScoutTree;
import org.eclipse.scout.rt.ui.swing.basic.tree.SwingScoutTree;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTreeEx;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.treefield.ISwingScoutTreeField;

public class SwingScoutTreeField
extends SwingScoutFieldComposite<ITreeField>
implements ISwingScoutTreeField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutTreeField.class);
    private ISwingScoutTree m_treeComposite;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel();
        container.add(label);
        this.setSwingLabel(label);
        this.setSwingContainer(container);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    @Override
    public JScrollPane getSwingScrollPane() {
        return this.m_treeComposite != null ? this.m_treeComposite.getSwingScrollPane() : null;
    }

    @Override
    public JTreeEx getSwingTree() {
        return this.m_treeComposite != null ? this.m_treeComposite.getSwingTree() : null;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setTreeFromScout();
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        this.getSwingLabel().setEnabled(b);
        if (this.getSwingScrollPane() != null) {
            this.getSwingScrollPane().getViewport().setOpaque(b);
        }
    }

    protected void setTreeFromScout() {
        ITree newTree;
        ITree oldTree = this.m_treeComposite != null ? (ITree)this.m_treeComposite.getScoutObject() : null;
        if (oldTree != (newTree = ((ITreeField)this.getScoutObject()).getTree())) {
            JComponent container = this.getSwingContainer();
            if (this.m_treeComposite != null) {
                container.remove(this.m_treeComposite.getSwingScrollPane());
                this.setSwingField(null);
                this.m_treeComposite.disconnectFromScout();
                this.m_treeComposite = null;
            }
            if (newTree != null) {
                IGroupBox g;
                SwingScoutTree newTreeComposite = new SwingScoutTree();
                newTreeComposite.createField(newTree, this.getSwingEnvironment());
                newTreeComposite.getSwingScrollPane().putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, LogicalGridDataBuilder.createField(this.getSwingEnvironment(), ((ITreeField)this.getScoutObject()).getGridData()));
                JScrollPane scrollPane = newTreeComposite.getSwingScrollPane();
                if (((ITreeField)this.getScoutObject()).getParentField() instanceof IGroupBox && (g = (IGroupBox)((ITreeField)this.getScoutObject()).getParentField()).isMainBox() && !g.isBorderVisible()) {
                    scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                }
                this.m_treeComposite = newTreeComposite;
                container.add(newTreeComposite.getSwingScrollPane());
                this.setSwingField(newTreeComposite.getSwingTree());
                container.revalidate();
                container.repaint();
            }
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("tree")) {
            this.setTreeFromScout();
        }
    }
}

