/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.splash;

import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.splash.EmbeddedSplashWindow;
import org.eclipse.scout.rt.ui.swing.splash.ISplashWindow;
import org.eclipse.scout.rt.ui.swing.splash.SplashWindow;

public class SplashProgressMonitor
extends NullProgressMonitor {
    private ISwingEnvironment m_env;
    private String m_name1;
    private String m_name2;
    private String m_displayText;
    private ISplashWindow m_splash;

    public SplashProgressMonitor(ISwingEnvironment env) {
        this.m_env = env;
    }

    public void beginTask(String name, int totalWork) {
        this.m_name1 = name;
        this.setNameInternal();
    }

    public void subTask(String name) {
        this.m_name2 = name;
        this.setNameInternal();
    }

    public void setTaskName(String name) {
        this.m_name1 = name;
        this.m_name2 = null;
        this.setNameInternal();
    }

    private void setNameInternal() {
        this.m_displayText = this.m_name2 != null ? this.m_name2 : (this.m_name1 != null ? this.m_name1 : "...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SplashProgressMonitor.this.m_splash != null) {
                    SplashProgressMonitor.this.m_splash.setStatusText(SplashProgressMonitor.this.m_displayText);
                }
            }
        });
    }

    public void done() {
        this.hideSplash();
    }

    public void showSplash() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SplashProgressMonitor.this.showSplashInSwingThread();
            }
        });
    }

    private void showSplashInSwingThread() {
        if (this.m_splash == null) {
            this.m_splash = !(this.m_env.getRootFrame() instanceof JFrame) && this.m_env.getRootFrame() instanceof RootPaneContainer ? new EmbeddedSplashWindow((RootPaneContainer)((Object)this.m_env.getRootFrame())) : new SplashWindow(this.m_env.getRootFrame());
            this.m_splash.setStatusText(this.m_displayText);
            this.m_splash.showSplash();
        }
    }

    public void hideSplash() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SplashProgressMonitor.this.hideSplashInSwingThread();
            }
        });
    }

    private void hideSplashInSwingThread() {
        if (this.m_splash != null) {
            this.m_splash.disposeSplash();
            this.m_splash = null;
        }
    }
}

