/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.splash;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.rt.ui.swing.ext.JFrameEx;
import org.eclipse.scout.rt.ui.swing.splash.ISplashWindow;
import org.osgi.framework.Version;

public class SplashWindow
extends JFrameEx
implements ISplashWindow {
    private static final long serialVersionUID = 1L;
    private String m_title;
    private String m_statusText = "...";
    private String m_versionText;
    private float m_animationPhase = -1.0f;

    public SplashWindow(Frame owner) {
        Object icons;
        Icon icon;
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        Version v = Version.emptyVersion;
        if (Platform.getProduct() != null) {
            this.m_title = Platform.getProduct().getName();
            v = Version.parseVersion((String)("" + Platform.getProduct().getDefiningBundle().getHeaders().get("Bundle-Version")));
        }
        if ((icon = UIManager.getIcon("Window.icon")) instanceof ImageIcon) {
            this.setIconImage(((ImageIcon)icon).getImage());
        }
        if ((icons = UIManager.getDefaults().get("Window.icons")) instanceof List) {
            ArrayList<Image> iconList = new ArrayList<Image>();
            for (Object ico : (List)icons) {
                if (!(ico instanceof Image)) continue;
                iconList.add((Image)ico);
            }
            this.setIconImages(iconList);
        }
        this.setTitle(this.m_title);
        this.setDefaultCloseOperation(3);
        this.setFont(new Font("Dialog", 0, 8));
        this.m_versionText = String.valueOf(v.getMajor()) + "." + v.getMinor() + "." + v.getMicro();
        JComponent pane = (JComponent)this.getContentPane();
        pane.setLayout(new BorderLayout());
        Icon imgIcon = UIManager.getIcon("Splash.icon");
        if (imgIcon == null) {
            imgIcon = new P_EmptyIcon();
        }
        JLabel iconLabel = new JLabel(new P_SplashScreen(imgIcon));
        iconLabel.setVerticalAlignment(1);
        pane.add((Component)iconLabel, "Center");
        Color c = UIManager.getColor("Splash.text");
        if (c != null) {
            this.setForeground(c);
        }
        this.pack();
        Dimension paneSize = this.getSize();
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    @Override
    public void showSplash() {
        this.setVisible(true);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
                while (SplashWindow.this.isVisible()) {
                    try {
                        1.sleep(25L);
                    }
                    catch (InterruptedException interruptedException) {}
                    SplashWindow.this.m_animationPhase = (float)(System.currentTimeMillis() / 3L % 1000L) / 1000.0f * 6.0f;
                    if (!(SplashWindow.this.m_animationPhase >= 0.0f) || !(SplashWindow.this.m_animationPhase <= 1.0f)) continue;
                    SplashWindow.this.repaint();
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void disposeSplash() {
        this.dispose();
    }

    @Override
    public void setStatusText(String s) {
        if (s == null) {
            s = "";
        }
        this.m_statusText = s;
        this.repaint();
    }

    private class P_EmptyIcon
    implements Icon {
        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            Color c1 = new Color(-3355444, true);
            Color c2 = new Color(0xCCCCCC, true);
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, c1, 0.0f, this.getIconHeight(), c2, true));
            g2d.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return 360;
        }

        @Override
        public int getIconHeight() {
            return 280;
        }
    }

    private class P_SplashScreen
    implements Icon {
        private Icon m_splashIcon;
        private int m_highlightSize = 200;
        private Point m_versionLocation;
        private Point m_statusTextLocation;

        public P_SplashScreen(Icon splashIcon) {
            this.m_splashIcon = splashIcon;
            this.m_versionLocation = (Point)UIManager.get("Splash.versionLocation");
            this.m_statusTextLocation = (Point)UIManager.get("Splash.statusTextLocation");
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            FontMetrics fm = g.getFontMetrics();
            int w = SplashWindow.this.getWidth();
            int h = SplashWindow.this.getHeight();
            this.m_splashIcon.paintIcon(c, g, x, y);
            Graphics2D g2d = (Graphics2D)g;
            Color c1 = new Color(0x66FFFFFF, true);
            Color c2 = new Color(0xFFFFFF, true);
            int phase = (int)(SplashWindow.this.m_animationPhase * (float)(w + this.m_highlightSize * 2)) - this.m_highlightSize;
            g2d.setPaint(new GradientPaint(phase - this.m_highlightSize, 0.0f, c2, phase, 0.0f, c1, true));
            g2d.fillRect(phase - this.m_highlightSize, 0, this.m_highlightSize, h);
            g2d.setPaint(new GradientPaint(phase, 0.0f, c1, phase + this.m_highlightSize, 0.0f, c2, true));
            g2d.fillRect(phase, 0, this.m_highlightSize, h);
            g2d.setPaint(SplashWindow.this.getForeground());
            Point vloc = this.m_versionLocation;
            if (vloc == null) {
                vloc = new Point();
                vloc.x = 12;
                vloc.y = h - fm.getHeight() - 10;
            }
            g.setColor(SplashWindow.this.getForeground());
            g.drawString(SplashWindow.this.m_versionText, vloc.x, vloc.y);
            if (SplashWindow.this.m_statusText != null) {
                Point sloc = this.m_statusTextLocation;
                if (sloc == null) {
                    sloc = new Point();
                    int offset = 12 + fm.stringWidth(SplashWindow.this.m_versionText) + 4;
                    sloc.x = Math.max((w - fm.stringWidth(SplashWindow.this.m_statusText)) / 2, offset);
                    sloc.y = h - fm.getHeight() - 10;
                }
                g.drawString(SplashWindow.this.m_statusText, sloc.x, sloc.y);
            }
        }

        @Override
        public int getIconHeight() {
            return this.m_splashIcon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.m_splashIcon.getIconWidth();
        }
    }
}

