/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window;

import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class SwingWindowManager {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingWindowManager.class);
    private static SwingWindowManager instance = new SwingWindowManager();
    private Window m_activeWindow;
    private ArrayList<Dialog> m_modalDialogStack = new ArrayList();

    public static SwingWindowManager getInstance() {
        return instance;
    }

    private SwingWindowManager() {
    }

    public void setActiveWindow(Window w) {
        this.m_activeWindow = w;
    }

    public Window getActiveWindow() {
        return this.m_activeWindow;
    }

    public void pushModalDialog(Dialog modalDialog) {
        this.m_modalDialogStack.add(modalDialog);
    }

    public void popModalDialog(Dialog verifyModalDialog) {
        if (verifyModalDialog != null) {
            int index = this.m_modalDialogStack.indexOf(verifyModalDialog);
            if (index >= 0) {
                if (index != this.m_modalDialogStack.size() - 1) {
                    LOG.warn("modal dialog stack is out of sync. Expected " + verifyModalDialog + " on top, but stack is: " + this.m_modalDialogStack);
                }
                this.m_modalDialogStack.remove(index);
            } else {
                LOG.warn("modal dialog stack is out of sync. Expected " + verifyModalDialog + " on top, but stack is empty");
            }
        }
    }

    public Dialog getActiveModalDialog() {
        if (this.m_modalDialogStack.isEmpty()) {
            return null;
        }
        return this.m_modalDialogStack.get(this.m_modalDialogStack.size() - 1);
    }
}

