/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.window.desktop.status.SwingProgressMonitor;
import org.eclipse.scout.rt.ui.swing.window.desktop.status.SwingProgressProvider;

public class ProgressHandler {
    private ISwingEnvironment m_env;
    private IProgressMonitor m_activeProgressMonitor;
    private String m_activeTaskName;
    private String m_activeSubTaskName;
    private double m_activeWorked;

    public ProgressHandler(ISwingEnvironment env) {
        this.m_env = env;
        this.initialize();
    }

    private void initialize() {
        Job.getJobManager().setProgressProvider((ProgressProvider)new SwingProgressProvider(){
            private Object dataLock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void activeMonitorChanged(SwingProgressMonitor monitor) {
                boolean handle = false;
                Object object = this.dataLock;
                synchronized (object) {
                    if (monitor == null) {
                        ProgressHandler.this.m_activeProgressMonitor = null;
                        ProgressHandler.this.m_activeTaskName = null;
                        ProgressHandler.this.m_activeSubTaskName = null;
                        ProgressHandler.this.m_activeWorked = 0.0;
                        handle = true;
                    } else if (monitor != ProgressHandler.this.m_activeProgressMonitor) {
                        ProgressHandler.this.m_activeProgressMonitor = (IProgressMonitor)monitor;
                        ProgressHandler.this.m_activeTaskName = monitor.getTaskName();
                        ProgressHandler.this.m_activeSubTaskName = monitor.getSubTaskName();
                        ProgressHandler.this.m_activeWorked = monitor.getWorked();
                        handle = true;
                    } else if (!(CompareUtility.equals((Object)ProgressHandler.this.m_activeTaskName, (Object)monitor.getTaskName()) && CompareUtility.equals((Object)ProgressHandler.this.m_activeSubTaskName, (Object)monitor.getSubTaskName()) && CompareUtility.equals((Object)((int)(ProgressHandler.this.m_activeWorked * 100.0)), (Object)((int)(monitor.getWorked() * 100.0))))) {
                        ProgressHandler.this.m_activeProgressMonitor = (IProgressMonitor)monitor;
                        ProgressHandler.this.m_activeTaskName = monitor.getTaskName();
                        ProgressHandler.this.m_activeSubTaskName = monitor.getSubTaskName();
                        ProgressHandler.this.m_activeWorked = monitor.getWorked();
                        handle = true;
                    }
                }
                if (handle) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ProgressHandler.this.handleProgressChangeInSwingThread();
                        }
                    };
                    ProgressHandler.this.m_env.postImmediateSwingJob(r);
                    SwingUtilities.invokeLater(r);
                }
            }
        });
    }

    protected void handleProgressChangeInSwingThread() {
    }

    public AbstractAction createStopAction() {
        return new P_SwingStopButtonAction();
    }

    public boolean hasProgressMonitor() {
        return this.m_activeProgressMonitor != null;
    }

    public double getActiveWorked() {
        return this.m_activeWorked;
    }

    public String getTaskName() {
        return StringUtility.concatenateTokens((String[])new String[]{this.m_activeTaskName, " - ", this.m_activeSubTaskName});
    }

    private class P_SwingStopButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_SwingStopButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent a) {
            Job[] jobs = Job.getJobManager().find(ClientJob.class);
            if (jobs != null) {
                Job[] jobArray = jobs;
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job j = jobArray[n2];
                    try {
                        j.cancel();
                    }
                    catch (Throwable throwable) {}
                    ++n2;
                }
            }
        }
    }
}

