/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.eclipse.scout.rt.ui.swing.window.desktop.ColumnSplitStrategyWithToolsView;

public class ToolsViewPlaceholder {
    private final Collection<ComponentListener> m_listeners = new ArrayList<ComponentListener>();
    private final ArrayList<JInternalFrame> m_frames = new ArrayList();
    private final P_FrameListener m_frameListener = new P_FrameListener();
    private final JDesktopPane m_desktopPane;
    private final ColumnSplitStrategyWithToolsView m_columnSplitStrategy;
    private int m_minWidth;
    private boolean m_expanded;

    public ToolsViewPlaceholder(JDesktopPane desktopPane, ColumnSplitStrategyWithToolsView columnSplitStrategy) {
        this.m_desktopPane = desktopPane;
        this.m_columnSplitStrategy = columnSplitStrategy;
    }

    private void fireComponentResized(ComponentEvent e) {
        for (ComponentListener l : this.m_listeners) {
            l.componentResized(e);
        }
    }

    public void addComponentListener(ComponentListener l) {
        this.m_listeners.add(l);
    }

    public void removeComponentListener(ComponentListener l) {
        this.m_listeners.remove(l);
    }

    public int getWidth() {
        if (this.m_frames.size() > 0) {
            return this.m_frames.get(this.m_frames.size() - 1).getWidth();
        }
        return 0;
    }

    public void addFrame(JInternalFrame frame) {
        this.m_frames.add(frame);
        frame.addComponentListener(this.m_frameListener);
        frame.addInternalFrameListener(this.m_frameListener);
    }

    public void removeFrame(JInternalFrame frame) {
        if (this.m_frames.contains(frame)) {
            this.m_frames.remove(frame);
            frame.removeComponentListener(this.m_frameListener);
            frame.removeInternalFrameListener(this.m_frameListener);
        }
    }

    public void setMinimumWidth(int minWidth) {
        this.m_minWidth = minWidth;
        this.m_columnSplitStrategy.setToolsViewMinWidth(this.m_minWidth);
        this.m_desktopPane.revalidate();
        this.m_desktopPane.repaint();
    }

    public void expandView() {
        if (this.m_minWidth > 0) {
            this.m_columnSplitStrategy.setToolsViewWidth(this.m_minWidth);
        }
        this.m_expanded = true;
        this.m_desktopPane.revalidate();
        this.m_desktopPane.repaint();
    }

    public void collapseView() {
        this.m_expanded = false;
        this.m_desktopPane.revalidate();
        this.m_desktopPane.repaint();
    }

    private class P_FrameListener
    extends InternalFrameAdapter
    implements ComponentListener {
        private P_FrameListener() {
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent e) {
            if (e.getInternalFrame().isVisible()) {
                ToolsViewPlaceholder.this.fireComponentResized(new ComponentEvent(e.getInternalFrame(), 101));
            }
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            ToolsViewPlaceholder.this.removeFrame(e.getInternalFrame());
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (e.getComponent().isVisible()) {
                ToolsViewPlaceholder.this.fireComponentResized(e);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (e.getComponent().isVisible()) {
                ToolsViewPlaceholder.this.fireComponentResized(e);
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (e.getComponent().isVisible()) {
                ToolsViewPlaceholder.this.fireComponentResized(e);
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

