/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.status;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.window.desktop.status.SwingProgressMonitor;

public class SwingProgressProvider
extends ProgressProvider
implements PropertyChangeListener {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingProgressProvider.class);
    private Object m_listLock = new Object();
    private LinkedList<SwingProgressMonitor> m_list = new LinkedList();

    public IProgressMonitor createMonitor(Job job) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("new " + (job.isSystem() ? "system  " : (job.isUser() ? "user    " : "default ")) + "Job: " + job);
        }
        if (job.isSystem()) {
            return new NullProgressMonitor();
        }
        final SwingProgressMonitor monitor = new SwingProgressMonitor();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void running(IJobChangeEvent event) {
                SwingProgressProvider.this.addInternal(monitor);
            }

            public void done(IJobChangeEvent event) {
                SwingProgressProvider.this.removeInternal(monitor);
            }
        });
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInternal(SwingProgressMonitor monitor) {
        Object object = this.m_listLock;
        synchronized (object) {
            this.m_list.add(0, monitor);
        }
        monitor.addPropertyChangeListener(this);
        this.activeMonitorChanged(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInternal(SwingProgressMonitor monitor) {
        SwingProgressMonitor next;
        monitor.removePropertyChangeListener(this);
        Object object = this.m_listLock;
        synchronized (object) {
            this.m_list.remove((Object)monitor);
            next = this.m_list.size() > 0 ? this.m_list.get(0) : null;
        }
        if (next != null) {
            this.activeMonitorChanged(next);
        } else {
            Job j = new Job("ProgressProvider, double-check"){

                protected IStatus run(IProgressMonitor m) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            int count;
                            Object object = SwingProgressProvider.this.m_listLock;
                            synchronized (object) {
                                count = SwingProgressProvider.this.m_list.size();
                            }
                            if (count == 0) {
                                SwingProgressProvider.this.activeMonitorChanged(null);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            j.setSystem(true);
            j.schedule(100L);
        }
    }

    @Override
    public final void propertyChange(PropertyChangeEvent e) {
        this.activeMonitorChanged((SwingProgressMonitor)((Object)e.getSource()));
    }

    protected void activeMonitorChanged(SwingProgressMonitor monitor) {
    }
}

