/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.JToggleButtonEx;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.HandCursorAdapater;

public abstract class AbstractJTab
extends JToggleButtonEx {
    private static final long serialVersionUID = 1L;
    public static final String PROP_ACTIVE = "active";
    private final ISwingEnvironment m_env;
    private boolean m_mouseOver = false;
    private IconGroup m_iconGroup = new IconGroup();
    private boolean m_active;

    public AbstractJTab(ISwingEnvironment env) {
        this.m_env = env;
        this.m_active = this.isSelected();
        this.setModel(new JToggleButton.ToggleButtonModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setPressed(boolean b) {
                if (b && this.isSelected()) {
                    this.fireActionPerformed(new ActionEvent(AbstractJTab.this, 1001, this.getActionCommand()));
                    return;
                }
                super.setPressed(b);
            }
        });
        this.installMouseAdapter();
        new HandCursorAdapater(this);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean oldActive = AbstractJTab.this.m_active;
                AbstractJTab.this.m_active = AbstractJTab.this.isSelected();
                AbstractJTab.this.firePropertyChange(AbstractJTab.PROP_ACTIVE, oldActive, AbstractJTab.this.m_active);
            }
        });
    }

    public void setIconGroupById(String iconId) {
        this.m_iconGroup = new IconGroup(this.m_env, iconId);
        this.repaint();
    }

    public IconGroup getIconGroup() {
        return this.m_iconGroup;
    }

    protected Icon getIconForTabState() {
        if (!this.isEnabled()) {
            return this.getIconGroup().getIcon(IconGroup.IconState.DISABLED);
        }
        if (this.isSelected()) {
            return this.getIconGroup().getIcon(IconGroup.IconState.SELECTED);
        }
        if (this.isMouseOver()) {
            return this.getIconGroup().getIcon(IconGroup.IconState.ROLLOVER);
        }
        return this.getIconGroup().getIcon(IconGroup.IconState.NORMAL);
    }

    public boolean isMouseOver() {
        return this.m_mouseOver;
    }

    protected void setMouseOver(boolean mouseOver) {
        this.m_mouseOver = mouseOver;
        this.repaint();
    }

    protected void installMouseAdapter() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AbstractJTab.this.setMouseOver(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AbstractJTab.this.setMouseOver(false);
            }
        });
    }
}

