/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.JLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.HandCursorAdapater;

public class CollapseButton
extends JPanelEx {
    private static final long serialVersionUID = 1L;
    private final ISwingEnvironment m_env;
    private JLabelEx m_label;
    private JLabelEx m_metricsLabel;
    private IconGroup m_arrowIcon;
    private Collection<String> m_potentialTexts;

    CollapseButton(ISwingEnvironment env) {
        this.m_env = env;
        this.setLayout(new Layout());
        this.setOpaque(false);
        this.m_label = new JLabelEx();
        this.add(this.m_label);
        this.m_label.setBorder(null);
        this.m_arrowIcon = new IconGroup("icon_slider");
        this.m_label.setIcon(this.m_arrowIcon.getIcon(IconGroup.IconState.NORMAL));
        this.m_label.setIconTextGap(7);
        this.m_label.setBold(true);
        this.m_label.setForeground(Color.WHITE);
        this.m_metricsLabel = new JLabelEx();
        this.m_metricsLabel.setIcon(this.m_arrowIcon.getIcon(IconGroup.IconState.NORMAL));
        this.m_metricsLabel.setIconTextGap(7);
        this.m_metricsLabel.setBold(true);
        this.m_metricsLabel.setBorder(null);
        this.m_metricsLabel.setVisible(false);
        new HandCursorAdapater(this);
        this.installListeners();
    }

    public void setText(String text) {
        this.m_label.setText(text);
    }

    public void setPotentialTexts(Collection<String> texts) {
        this.m_potentialTexts = texts;
        this.revalidate();
    }

    private void installListeners() {
        this.m_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                CollapseButton.this.m_label.setIcon(CollapseButton.this.m_arrowIcon.getIcon(IconGroup.IconState.NORMAL));
                CollapseButton.this.setVisible(false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CollapseButton.this.m_label.setIcon(CollapseButton.this.m_arrowIcon.getIcon(IconGroup.IconState.ROLLOVER));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CollapseButton.this.m_label.setIcon(CollapseButton.this.m_arrowIcon.getIcon(IconGroup.IconState.NORMAL));
            }
        });
    }

    private class Layout
    extends AbstractLayoutManager2 {
        private Dimension m_size;

        private Layout() {
        }

        @Override
        protected void validateLayout(Container parent) {
            Dimension d = new Dimension();
            if (CollapseButton.this.m_potentialTexts != null) {
                for (String s : CollapseButton.this.m_potentialTexts) {
                    CollapseButton.this.m_metricsLabel.setText(s);
                    Dimension t = SwingLayoutUtility.getPreferredLabelSize(CollapseButton.this.m_metricsLabel, 10240);
                    d.width = Math.max(d.width, t.width);
                    d.height = Math.max(d.height, t.height);
                }
            } else {
                d = SwingLayoutUtility.getPreferredLabelSize(CollapseButton.this.m_label, 10240);
            }
            Insets insets = parent.getInsets();
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            this.m_size = d;
        }

        @Override
        protected Dimension getLayoutSize(Container parent, int sizeflag) {
            return this.m_size;
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            CollapseButton.this.m_label.setBounds(new Rectangle(insets.left, insets.top, parent.getWidth() - insets.left - insets.right, parent.getHeight() - insets.top - insets.bottom));
        }
    }
}

