/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.ForwardButton;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.NavigationWidgetButton;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.StopRefreshButton;

public class JNavigationWidget
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int SHADOW_DISTANCE = 2;
    private static final Dimension SIZE = new Dimension(111, 42);
    private static final Point HISTORY_MENU_LOCATION = new Point(38, 38);
    private ISwingEnvironment m_env;
    private NavigationWidgetButton m_mouseOverButton;
    private ButtonName m_dropshadowBelowButton = ButtonName.NONE;
    private Map<ButtonName, NavigationWidgetButton> m_buttonMap = new HashMap<ButtonName, NavigationWidgetButton>();

    public JNavigationWidget(ISwingEnvironment env) {
        this.m_env = env;
        this.setPreferredSize(SIZE);
        this.setOpaque(false);
        this.initButtons();
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JNavigationWidget.this.detectMouseOverButton(e.getX(), e.getY());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                JNavigationWidget.this.setMouseOverButton(ButtonName.NONE);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JNavigationWidget.this.setPressedButton(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JNavigationWidget.this.setPressedButton(false);
                JNavigationWidget.this.buttonClicked(e.getButton());
            }
        });
        env.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("busy".equals(evt.getPropertyName())) {
                    Boolean busy = (Boolean)evt.getNewValue();
                    JNavigationWidget.this.getStopRefreshButton().setLoading(busy);
                }
            }
        });
    }

    private void initButtons() {
        NavigationWidgetButton back = new NavigationWidgetButton(ButtonName.BACK, this);
        back.loadButtonStates("nw_btn_back");
        back.loadIconStates("nw_ico_back");
        back.m_buttonPos = new Point(5, 4);
        back.m_iconPos = new Point(13, 9);
        this.m_buttonMap.put(ButtonName.BACK, back);
        this.addDisabledListener(back);
        final ForwardButton forward = new ForwardButton(this);
        forward.loadButtonStates("nw_btn_forward");
        forward.loadIconStates("nw_ico_forward");
        forward.m_buttonPos = new Point(39, 4);
        forward.m_iconPos = new Point(44, 9);
        forward.loadHistoryIcon("nw_ico_history");
        forward.m_historyIconPos = new Point(57, 9);
        forward.setEnabled(false);
        forward.setHistoryEnabled(back.isEnabled());
        this.m_buttonMap.put(ButtonName.FORWARD, forward);
        this.addDisabledListener(forward);
        StopRefreshButton stopRefresh = new StopRefreshButton(this);
        stopRefresh.loadButtonStates("nw_btn_stop_refresh");
        stopRefresh.loadIconStates("nw_ico_refresh");
        stopRefresh.m_buttonPos = new Point(73, 4);
        stopRefresh.m_iconPos = new Point(79, 11);
        stopRefresh.loadStopIcon("nw_ico_stop");
        stopRefresh.loadGlowAnimation("nw_glow");
        stopRefresh.showStopIcon();
        this.m_buttonMap.put(ButtonName.STOP_REFRESH, stopRefresh);
        this.addDisabledListener(stopRefresh);
        PropertyChangeListener historyEnabledListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    boolean enabled = (Boolean)evt.getNewValue();
                    forward.setHistoryEnabled(enabled);
                }
            }
        };
        back.addPropertyChangeListener(historyEnabledListener);
    }

    private void addDisabledListener(NavigationWidgetButton button) {
        button.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled;
                if ("enabled".equals(evt.getPropertyName()) && !(enabled = ((Boolean)evt.getNewValue()).booleanValue())) {
                    NavigationWidgetButton disabledButton = (NavigationWidgetButton)evt.getSource();
                    if (JNavigationWidget.this.m_mouseOverButton != null && JNavigationWidget.this.m_mouseOverButton.getName() == disabledButton.getName()) {
                        JNavigationWidget.this.setMouseOverButton(ButtonName.NONE);
                    }
                }
            }
        });
    }

    private void detectMouseOverButton(int x, int y) {
        ButtonName moButtonName = ButtonName.getMouseOverButton(x, y);
        this.setMouseOverButton(moButtonName);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintDropshadow(g);
        this.paintButtons(g);
    }

    private void paintDropshadow(Graphics g) {
        Icon icon = Activator.getIcon(this.m_dropshadowBelowButton.m_dropshadowIcon);
        if (icon != null) {
            icon.paintIcon(this, g, 2, 2);
        }
    }

    private NavigationWidgetButton getButton(ButtonName button) {
        return this.m_buttonMap.get((Object)button);
    }

    private void paintButtons(Graphics g) {
        this.getButton(ButtonName.BACK).paintComponent(this, g);
        this.getButton(ButtonName.FORWARD).paintComponent(this, g);
        this.getButton(ButtonName.STOP_REFRESH).paintComponent(this, g);
    }

    private void setPressedButton(boolean pressed) {
        if (this.m_mouseOverButton != null) {
            this.m_mouseOverButton.setPressed(pressed);
        }
    }

    private void buttonClicked(int button) {
        if (this.m_mouseOverButton != null) {
            this.m_mouseOverButton.buttonClicked(button);
        }
    }

    private void setMouseOverButton(ButtonName moButtonName) {
        if (this.m_mouseOverButton != null) {
            this.m_mouseOverButton.setMouseOver(false);
            this.m_mouseOverButton.setPressed(false);
        }
        this.m_mouseOverButton = this.getButton(moButtonName);
        this.m_dropshadowBelowButton = this.m_mouseOverButton != null && this.m_mouseOverButton.isEnabled() ? moButtonName : ButtonName.NONE;
        if (this.m_mouseOverButton != null) {
            this.m_mouseOverButton.setMouseOver(true);
        }
    }

    public NavigationWidgetButton getBackButton() {
        return this.getButton(ButtonName.BACK);
    }

    public ForwardButton getForwardButton() {
        return (ForwardButton)this.getButton(ButtonName.FORWARD);
    }

    public StopRefreshButton getStopRefreshButton() {
        return (StopRefreshButton)this.getButton(ButtonName.STOP_REFRESH);
    }

    public Point getHistoryMenuLocation() {
        return HISTORY_MENU_LOCATION;
    }

    static enum ButtonName {
        NONE(new Rectangle(), "nw_shadow"),
        BACK(new Rectangle(5, 4, 33, 32), "nw_shadow_back"),
        FORWARD(new Rectangle(39, 4, 42, 32), "nw_shadow_forward"),
        STOP_REFRESH(new Rectangle(82, 4, 22, 32), "nw_shadow_stop_refresh.png");

        private Rectangle m_bounds;
        private String m_dropshadowIcon;

        private ButtonName(Rectangle bounds, String dropshadowIcon) {
            this.m_bounds = bounds;
            this.m_dropshadowIcon = dropshadowIcon;
        }

        static ButtonName getMouseOverButton(int x, int y) {
            ButtonName[] buttonNameArray = ButtonName.values();
            int n = buttonNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                ButtonName buttonName = buttonNameArray[n2];
                if (buttonName.m_bounds.contains(x, y)) {
                    return buttonName;
                }
                ++n2;
            }
            return NONE;
        }
    }
}

