/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.synth.SynthLookAndFeel;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJTabBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.CollapseButton;

public class JToolTabsBar
extends AbstractJTabBar {
    private static final long serialVersionUID = 1L;
    public static final String PROP_COLLAPSED = "collapsed";
    public static final String PROP_MINIMUM_SIZE = "minimumSize";
    private final ISwingEnvironment m_env;
    private Icon m_activeTabIcon;
    private boolean m_collapsed = true;
    private int m_preferredWidth = 0;
    private CollapseButton m_collapseButton;

    JToolTabsBar(ISwingEnvironment env) {
        this.m_env = env;
        this.m_activeTabIcon = Activator.getIcon("tool_tab");
        this.setLayout(new Layout());
        this.setName("Synth.ToolTabsBar");
        if (!(UIManager.getLookAndFeel() instanceof SynthLookAndFeel)) {
            this.setOpaque(true);
            this.setBackground(new Color(6793422));
        }
    }

    void rebuild(IDesktop desktop) {
        this.removeAll();
        this.addCollapseButton();
        this.add(SwingUtility.createGlue(0, 0, true, false));
        ArrayList<String> textList = new ArrayList<String>();
        IToolButton[] iToolButtonArray = desktop.getToolButtons();
        int n = iToolButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolButton a = iToolButtonArray[n2];
            ISwingScoutAction button = this.m_env.createAction(this, (IAction)a);
            if (button != null) {
                this.addToolTab((AbstractButton)button.getSwingField());
                textList.add(a.getText());
            }
            ++n2;
        }
        this.m_collapseButton.setPotentialTexts(textList);
    }

    @Override
    protected void tabActivated(AbstractButton tab) {
        Dimension oldMin = this.getMinimumSize();
        if (this.m_collapsed) {
            this.expandBar();
        }
        this.m_collapseButton.setText(tab.getText());
        this.firePropertyChange(PROP_MINIMUM_SIZE, oldMin, this.getMinimumSize());
        this.revalidateAndRepaint();
    }

    private void expandBar() {
        this.m_collapseButton.setVisible(true);
        this.revalidateAndRepaint();
        this.setCollapsed(false);
    }

    private void collapseBar() {
        if (this.isCollapsed()) {
            return;
        }
        if (this.getActiveTab() != null) {
            this.getActiveTab().setSelected(false);
        }
        this.m_preferredWidth = 0;
        this.m_collapseButton.setVisible(false);
        this.revalidateAndRepaint();
        this.setCollapsed(true);
    }

    public boolean isCollapsed() {
        return this.m_collapsed;
    }

    private void setCollapsed(boolean collapsed) {
        boolean oldCollapsed = this.m_collapsed;
        this.m_collapsed = collapsed;
        this.firePropertyChange(PROP_COLLAPSED, oldCollapsed, this.m_collapsed);
    }

    private void revalidateAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    private void addCollapseButton() {
        this.m_collapseButton = new CollapseButton(this.m_env){
            private static final long serialVersionUID = 1L;

            @Override
            public void hide() {
                super.hide();
                JToolTabsBar.this.collapseBar();
            }
        };
        if (this.isCollapsed()) {
            this.m_collapseButton.setVisible(false);
        }
        this.add(this.m_collapseButton);
    }

    private void addToolTab(AbstractButton tab) {
        tab.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.add(tab);
        this.addActiveTabListener(tab);
        this.addToolBarChangedListener(tab);
    }

    private void addToolBarChangedListener(AbstractButton tab) {
        tab.addPropertyChangeListener("changedToolTabState", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean allTabsAreInactive = true;
                Component[] componentArray = JToolTabsBar.this.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof AbstractButton && ((AbstractButton)c).isSelected()) {
                        allTabsAreInactive = false;
                        break;
                    }
                    ++n2;
                }
                if (allTabsAreInactive) {
                    JToolTabsBar.this.collapseBar();
                }
            }
        });
    }

    public void adjustWidthToToolsView(int newValue) {
        if (newValue != this.m_preferredWidth) {
            this.m_preferredWidth = newValue;
            this.revalidateAndRepaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintActiveTabOnBackground(g);
    }

    private void paintActiveTabOnBackground(Graphics g) {
        AbstractButton tab = this.getActiveTab();
        Icon icon = this.m_activeTabIcon;
        if (tab != null && icon != null) {
            int x = tab.getX();
            int y = this.getHeight() - icon.getIconHeight();
            int w = tab.getWidth();
            int h = icon.getIconHeight();
            Shape oldClip = g.getClip();
            g.setClip(x, y, 6, h);
            icon.paintIcon(this, g, x, y);
            g.setClip(x + 6, y, w - 12, h);
            int k = 0;
            while (k < w) {
                icon.paintIcon(this, g, x + k, y);
                k += icon.getIconWidth();
            }
            g.setClip(x + w - 6, y, 6, h);
            icon.paintIcon(this, g, x, y);
            g.setClip(oldClip);
        }
    }

    private class Layout
    extends FlowLayoutEx {
        Layout() {
            super(2, 0, 0, 0);
            this.setFillVertical(true);
            this.setFillHorizontal(true);
        }

        @Override
        protected Dimension getLayoutSize(Container parent, int sizeflag) {
            Dimension d;
            if (JToolTabsBar.this.isCollapsed()) {
                d = super.getLayoutSize(parent, 1);
            } else {
                d = super.getLayoutSize(parent, 1);
                switch (sizeflag) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (JToolTabsBar.this.m_preferredWidth <= 0) break;
                        d.width = Math.max(d.width, JToolTabsBar.this.m_preferredWidth);
                        break;
                    }
                    case 2: {
                        d.width = 10240;
                    }
                }
            }
            d.height = 30;
            return d;
        }
    }

    private static final class P_ToolTabData {
        String title;
        String icon;
        String tooltip;

        private P_ToolTabData(String title, String icon, String tooltip) {
            this.title = title;
            this.icon = icon;
            this.tooltip = tooltip;
        }
    }
}

