/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.synth.SynthLookAndFeel;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.window.desktop.menubar.SwingScoutMainMenuPopup;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJTabBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.HandCursorAdapater;

public class JViewTabsBar
extends AbstractJTabBar {
    private static final long serialVersionUID = 1L;
    private Icon m_activeTabLeftIcon;
    private Icon m_activeTabRightIcon;
    private IconGroup m_menuIcon;
    private IDesktop m_desktop;
    private JLabel m_menuLabel;
    private SwingScoutMainMenuPopup m_popupMenu;
    private ISwingEnvironment m_env;

    JViewTabsBar(ISwingEnvironment env) {
        this.m_env = env;
        this.m_activeTabLeftIcon = Activator.getIcon("view_tab_left");
        this.m_activeTabRightIcon = Activator.getIcon("view_tab_right");
        this.m_menuIcon = new IconGroup("icon_menu");
        this.setName("Synth.ViewTabsBar");
        this.setLayout(new Layout());
        this.setOpaque(true);
        if (!(UIManager.getLookAndFeel() instanceof SynthLookAndFeel)) {
            this.setBackground(new Color(14543860));
        }
    }

    private boolean isShowMenuBar() {
        return "toolbar".equals(UIManager.get("MenuBar.policy"));
    }

    private AbstractButton addViewTab(AbstractButton tab) {
        this.addActiveTabListener(tab);
        tab.setBorder(new EmptyBorder(3, 12, 0, 14));
        this.add(tab);
        return tab;
    }

    private void addMenuIcon() {
        this.m_menuLabel = new JLabel();
        this.m_menuLabel.setIcon(this.m_menuIcon.getIcon(IconGroup.IconState.NORMAL));
        this.m_menuLabel.setBorder(new EmptyBorder(3, 3, 2, 0));
        new HandCursorAdapater(this.m_menuLabel);
        this.m_menuLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JViewTabsBar.this.m_popupMenu.getSwingPopupMenu().show(JViewTabsBar.this.m_menuLabel, 0, JViewTabsBar.this.m_menuLabel.getHeight());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JViewTabsBar.this.m_menuLabel.setIcon(JViewTabsBar.this.m_menuIcon.getIcon(IconGroup.IconState.ROLLOVER));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JViewTabsBar.this.m_menuLabel.setIcon(JViewTabsBar.this.m_menuIcon.getIcon(IconGroup.IconState.NORMAL));
            }
        });
        this.add(this.m_menuLabel);
    }

    void rebuild(IDesktop desktop) {
        this.removeAll();
        if (this.isShowMenuBar()) {
            this.addMenuIcon();
            this.add(SwingUtility.createGlue(5, 5, false, false));
        }
        IViewButton[] iViewButtonArray = desktop.getViewButtons();
        int n = iViewButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewButton a = iViewButtonArray[n2];
            ISwingScoutAction button = this.m_env.createAction(this, (IAction)a);
            if (button != null) {
                this.addViewTab((AbstractButton)button.getSwingField());
            }
            ++n2;
        }
        this.add(SwingUtility.createGlue(0, 0, true, false));
        if (this.isShowMenuBar()) {
            this.m_popupMenu = new SwingScoutMainMenuPopup();
            this.m_popupMenu.createField(desktop, this.m_env);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintActiveTabOnBackground(g);
    }

    private void paintActiveTabOnBackground(Graphics g) {
        AbstractButton tab = this.getActiveTab();
        if (tab == null) {
            return;
        }
        Insets i = tab.getInsets();
        int y = i.top;
        int x = tab.getX() + i.left - this.m_activeTabLeftIcon.getIconWidth();
        this.m_activeTabLeftIcon.paintIcon(this, g, x, y);
        x = tab.getX() + tab.getWidth() - i.right;
        this.m_activeTabRightIcon.paintIcon(this, g, x, y);
        x = tab.getX() + i.left;
        g.setColor(Color.WHITE);
        g.fillRect(x, y, tab.getWidth() - i.right - i.left, this.getHeight() - y);
    }

    private class Layout
    extends FlowLayoutEx {
        Layout() {
            super(2, 0, 0, 0);
            this.setFillVertical(true);
            this.setFillHorizontal(true);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension d = super.minimumLayoutSize(parent);
            d.height = 30;
            return d;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = super.preferredLayoutSize(parent);
            d.height = 30;
            return d;
        }

        @Override
        public Dimension maximumLayoutSize(Container parent) {
            Dimension d = super.maximumLayoutSize(parent);
            d.width = 10240;
            d.height = 30;
            return d;
        }
    }
}

