/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.navigation.INavigationHistoryService;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryEvent;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryListener;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JButtonEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.service.SERVICES;

public class LegacySwingScoutToolBar
extends SwingScoutComposite<IDesktop> {
    private int m_topLevelMenuCount;
    private JButton m_navBackButton;
    private JButton m_navFwdButton;
    private JButton m_navMenuButton;
    private JPanelEx m_viewTabPanel;
    private JPanelEx m_toolTabPanel;
    private NavigationHistoryListener m_scoutNavListener;

    @Override
    protected void initializeSwing() {
        this.m_topLevelMenuCount = ((IDesktop)this.getScoutObject()).getMenus().length;
        JToolBar toolBar = new JToolBar();
        toolBar.setLayout(new BorderLayoutEx(0, 0));
        toolBar.setMargin(new Insets(4, 4, 4, 4));
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        JPanelEx navigationPanel = new JPanelEx(new FlowLayoutEx(2, 0, 0));
        navigationPanel.setOpaque(false);
        this.m_navBackButton = this.createNavigationButton("navigation_backward", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LegacySwingScoutToolBar.this.handleNavigationBackFromSwing();
            }
        });
        navigationPanel.add(this.m_navBackButton);
        this.m_navFwdButton = this.createNavigationButton("navigation_forward", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LegacySwingScoutToolBar.this.handleNavigationForwardFromSwing();
            }
        });
        navigationPanel.add(this.m_navFwdButton);
        this.m_navMenuButton = this.createNavigationButton("navigation_menu", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LegacySwingScoutToolBar.this.handleNavigationMenuFromSwing();
            }
        });
        navigationPanel.add(this.m_navMenuButton);
        this.m_viewTabPanel = new JPanelEx(new FlowLayoutEx(2, 0, 0));
        this.m_viewTabPanel.setOpaque(false);
        this.m_toolTabPanel = new JPanelEx(new FlowLayoutEx(2, 0, 0));
        this.m_toolTabPanel.setOpaque(false);
        toolBar.add((Component)navigationPanel, "Before");
        toolBar.add((Component)this.m_toolTabPanel, "Center");
        toolBar.add((Component)this.m_viewTabPanel, "After");
        this.setSwingField(toolBar);
        this.rebuildViewTabs();
        this.rebuildToolTabs();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        new ClientSyncJob("add navigation listener", this.getSwingEnvironment().getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                if (LegacySwingScoutToolBar.this.m_scoutNavListener == null) {
                    LegacySwingScoutToolBar.this.m_scoutNavListener = new NavigationHistoryListener(){

                        public void navigationChanged(NavigationHistoryEvent e) {
                            LegacySwingScoutToolBar.this.handleNavigationChangedFromScout();
                        }
                    };
                    ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).addNavigationHistoryListener(LegacySwingScoutToolBar.this.m_scoutNavListener);
                    LegacySwingScoutToolBar.this.handleNavigationChangedFromScout();
                }
            }
        }.schedule();
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        new ClientSyncJob("remove navigation listener", this.getSwingEnvironment().getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                if (LegacySwingScoutToolBar.this.m_scoutNavListener != null) {
                    INavigationHistoryService nav = (INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class);
                    if (nav != null) {
                        nav.removeNavigationHistoryListener(LegacySwingScoutToolBar.this.m_scoutNavListener);
                    }
                    LegacySwingScoutToolBar.this.m_scoutNavListener = null;
                }
            }
        }.schedule();
    }

    @Override
    protected boolean isHandleScoutPropertyChange(String name, Object newValue) {
        return false;
    }

    protected void handleNavigationBackFromSwing() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).stepBackward();
                }
                catch (ProcessingException processingException) {}
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    protected void handleNavigationForwardFromSwing() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).stepForward();
                }
                catch (ProcessingException processingException) {}
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    protected void handleNavigationMenuFromSwing() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                IMenu[] scoutMenus = ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).getMenus();
                new SwingPopupWorker(LegacySwingScoutToolBar.this.getSwingEnvironment(), LegacySwingScoutToolBar.this.m_navMenuButton, new Point(0, 0), scoutMenus).enqueue();
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 5678L);
    }

    protected void handleNavigationChangedFromScout() {
        INavigationHistoryService service = (INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class);
        final boolean backEnabled = service.hasBackwardBookmarks();
        final boolean forewardEnabled = service.hasForwardBookmarks();
        final boolean menuEnabled = backEnabled || forewardEnabled;
        Runnable t = new Runnable(){

            @Override
            public void run() {
                LegacySwingScoutToolBar.this.updateNavigationTab(backEnabled, forewardEnabled, menuEnabled);
            }
        };
        this.getSwingEnvironment().invokeSwingLater(t);
    }

    public boolean isEmpty() {
        return this.m_topLevelMenuCount == 0;
    }

    public JToolBar getSwingToolBar() {
        return (JToolBar)this.getSwingField();
    }

    public JPanel getSwingToolsPanel() {
        return this.m_toolTabPanel;
    }

    private void updateNavigationTab(boolean backEnabled, boolean forewardEnabled, boolean menuEnabled) {
        this.m_navBackButton.setEnabled(backEnabled);
        this.m_navFwdButton.setEnabled(forewardEnabled);
        this.m_navMenuButton.setEnabled(menuEnabled);
    }

    private void rebuildViewTabs() {
        this.m_viewTabPanel.removeAll();
        IViewButton[] iViewButtonArray = ((IDesktop)this.getScoutObject()).getViewButtons();
        int n = iViewButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewButton a = iViewButtonArray[n2];
            ISwingScoutAction button = this.getSwingEnvironment().createAction(this.m_viewTabPanel, (IAction)a);
            if (button != null) {
                this.m_viewTabPanel.add(button.getSwingField());
            }
            ++n2;
        }
    }

    private void rebuildToolTabs() {
        this.m_toolTabPanel.removeAll();
        IToolButton[] iToolButtonArray = ((IDesktop)this.getScoutObject()).getToolButtons();
        int n = iToolButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolButton a = iToolButtonArray[n2];
            ISwingScoutAction button = this.getSwingEnvironment().createAction(this.m_toolTabPanel, (IAction)a);
            if (button != null) {
                this.m_toolTabPanel.add(button.getSwingField());
            }
            ++n2;
        }
    }

    private JButton createNavigationButton(String iconId, Action a) {
        JButtonEx b = new JButtonEx(a);
        b.setIcon(Activator.getIcon(iconId));
        b.setDisabledIcon(Activator.getIcon(String.valueOf(iconId) + "_disabled"));
        b.setPressedIcon(Activator.getIcon(String.valueOf(iconId) + "_pressed"));
        b.setRolloverIcon(Activator.getIcon(String.valueOf(iconId) + "_rollover"));
        b.setOpaque(true);
        b.setContentAreaFilled(false);
        b.setBorder(null);
        b.setBorderPainted(false);
        b.setFocusPainted(false);
        return b;
    }
}

