/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.JNavigationWidget;

public class NavigationWidgetButton {
    protected static final String PROP_ENABLED = "enabled";
    private PropertyChangeSupport m_support = new PropertyChangeSupport(this);
    private JComponent m_parent;
    private Icon[] m_button;
    private Icon[] m_icon;
    Point m_buttonPos;
    Point m_iconPos;
    private boolean m_enabled = true;
    private boolean m_mouseOver = false;
    private boolean m_pressed = false;
    private AbstractAction m_primaryAction;
    private AbstractAction m_secondaryAction;
    private JNavigationWidget.ButtonName m_name;

    NavigationWidgetButton(JNavigationWidget.ButtonName name, JComponent parent) {
        this.m_name = name;
        this.m_parent = parent;
    }

    Icon getButton() {
        return this.m_button[this.m_mouseOver ? 1 : 0];
    }

    protected Icon getTriStateIcon(Icon[] triStateIcon, boolean enabled) {
        int index = 0;
        if (!enabled) {
            index = 2;
        } else if (this.isMouseOver()) {
            index = 1;
        }
        return triStateIcon[index];
    }

    Icon getIcon() {
        return this.getTriStateIcon(this.m_icon, this.isEnabled());
    }

    public boolean isPressed() {
        return this.m_pressed;
    }

    public void setPressed(boolean pressed) {
        if (this.isEnabled()) {
            boolean oldPressed = this.m_pressed;
            this.m_pressed = pressed;
            if (oldPressed != this.m_pressed) {
                this.repaintParent();
            }
        }
    }

    protected void performAction(AbstractAction action) {
        action.actionPerformed(new ActionEvent(this.m_parent, 1001, null));
    }

    public void buttonClicked(int button) {
        this.performAction(this.m_primaryAction);
    }

    public boolean isMouseOver() {
        return this.m_mouseOver;
    }

    public void setMouseOver(boolean mouseOver) {
        if (this.isEnabled()) {
            boolean oldMouseOver = this.m_mouseOver;
            this.m_mouseOver = mouseOver;
            if (oldMouseOver != this.m_mouseOver) {
                this.repaintParent();
            }
        }
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.m_enabled;
        this.m_enabled = enabled;
        this.m_support.firePropertyChange(PROP_ENABLED, oldEnabled, this.m_enabled);
        if (oldEnabled != this.m_enabled) {
            if (!enabled) {
                this.m_mouseOver = false;
                this.m_pressed = false;
            }
            this.repaintParent();
        }
    }

    public void loadButtonStates(String iconUrl) {
        this.m_button = new Icon[2];
        this.m_button[0] = Activator.getIcon(iconUrl);
        this.m_button[1] = Activator.getIcon(String.valueOf(iconUrl) + "_mo");
    }

    public void loadIconStates(String iconUrl) {
        this.m_icon = this.loadTriStateIcon(iconUrl);
    }

    protected Icon[] loadTriStateIcon(String iconUrl) {
        Icon[] icon = new Icon[]{Activator.getIcon(iconUrl), Activator.getIcon(String.valueOf(iconUrl) + "_mo"), Activator.getIcon(String.valueOf(iconUrl) + "_da")};
        return icon;
    }

    public final void paintComponent(Component c, Graphics g) {
        this.paintButton(c, g);
        this.paintIcon(c, g);
    }

    protected void paintButton(Component c, Graphics g) {
        this.paintPressedImage(this.getButton(), this.m_buttonPos, this.m_pressed, c, g);
    }

    protected void paintIcon(Component c, Graphics g) {
        this.paintPressedImage(this.getIcon(), this.m_iconPos, this.m_pressed, c, g);
    }

    protected void paintPressedImage(Icon img, Point p, boolean pressed, Component c, Graphics g) {
        int x = p.x;
        int y = p.y;
        if (pressed) {
            ++x;
            ++y;
        }
        img.paintIcon(c, g, x, y);
    }

    protected void repaintParent() {
        this.m_parent.repaint();
    }

    void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_support.addPropertyChangeListener(l);
    }

    void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_support.removePropertyChangeListener(l);
    }

    public final void setPrimaryAction(AbstractAction a) {
        this.m_primaryAction = a;
    }

    public final AbstractAction getPrimaryAction() {
        return this.m_primaryAction;
    }

    public final void setSecondaryAction(AbstractAction a) {
        this.m_secondaryAction = a;
    }

    public final AbstractAction getSecondaryAction() {
        return this.m_secondaryAction;
    }

    public JNavigationWidget.ButtonName getName() {
        return this.m_name;
    }
}

